/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBAuditCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityDetailMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops.AbstractSearchOperation;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryTimeoutException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.IXtdb;
import xtdb.api.IXtdbDatasource;
import xtdb.api.XtdbDocument;

public abstract class AbstractEntitySearchOperation
extends AbstractSearchOperation {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntitySearchOperation.class);

    protected AbstractEntitySearchOperation(XTDBOMRSRepositoryConnector xtdb, String entityTypeGUID, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String userId) {
        super(xtdb, entityTypeGUID, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize, userId);
    }

    public List<EntityDetail> getResults() throws TypeErrorException, RepositoryErrorException {
        List<EntityDetail> results;
        if (this.existingDB != null) {
            try {
                Collection<List<?>> xtdbResults = this.runQuery(this.existingDB);
                log.debug("Found results: {}", xtdbResults);
                return this.translateResults(xtdbResults, this.existingDB);
            }
            catch (TimeoutException e) {
                throw new RepositoryTimeoutException(XTDBErrorCode.QUERY_TIMEOUT.getMessageDefinition(this.xtdb.getRepositoryName()), this.getClass().getName(), this.getClass().getName(), (Throwable)e);
            }
        }
        IXtdb xtdbAPI = this.xtdb.getXtdbAPI();
        try (IXtdbDatasource db = this.asOfTime == null ? xtdbAPI.openDB() : xtdbAPI.openDB(this.asOfTime);){
            Collection<List<?>> xtdbResults = this.runQuery(db);
            log.debug("Found results: {}", xtdbResults);
            results = this.translateResults(xtdbResults, db);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XTDBErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), this.getClass().getName(), this.getClass().getName(), (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new RepositoryTimeoutException(XTDBErrorCode.QUERY_TIMEOUT.getMessageDefinition(""), this.getClass().getName(), this.getClass().getName(), (Throwable)e);
        }
        return results;
    }

    private List<EntityDetail> translateResults(Collection<List<?>> xtdbResults, IXtdbDatasource db) {
        String methodName = "translateResults";
        ArrayList<EntityDetail> results = null;
        if (xtdbResults != null) {
            results = new ArrayList<EntityDetail>();
            for (List<?> xtdbResult : xtdbResults) {
                String docRef = (String)xtdbResult.get(0);
                XtdbDocument xtdbDoc = AbstractEntitySearchOperation.getXtdbObjectByReference(db, docRef);
                if (xtdbDoc == null) {
                    this.xtdb.logProblem(this.getClass().getName(), "translateResults", XTDBAuditCode.MAPPING_FAILURE, null, "entity", docRef, "cannot be retrieved from XTDB");
                    continue;
                }
                EntityDetailMapping edm = new EntityDetailMapping(this.xtdb, xtdbDoc);
                EntityDetail ed = edm.toEgeria();
                if (ed != null) {
                    results.add(ed);
                    continue;
                }
                this.xtdb.logProblem(this.getClass().getName(), "translateResults", XTDBAuditCode.MAPPING_FAILURE, null, "entity", docRef, "cannot be mapped to EntityDetail");
            }
        }
        return results;
    }
}

