/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache;

import clojure.lang.Keyword;
import java.util.Objects;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.AbstractMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;

public class PropertyKeywords {
    private final TypeDefAttribute attribute;
    private final String simpleName;
    private final String embeddedPath;
    private final String searchablePath;

    public PropertyKeywords(String namespace, String typeName, String propertyName, TypeDefAttribute attribute) {
        this.attribute = attribute;
        this.simpleName = propertyName;
        this.embeddedPath = PropertyKeywords.getSerializedPropertyKeyword(namespace, propertyName);
        this.searchablePath = PropertyKeywords.getSearchableValueKeyword(namespace, typeName, propertyName);
    }

    public TypeDefAttribute getAttribute() {
        return this.attribute;
    }

    public Keyword getEmbeddedKeyword() {
        return Keyword.intern((String)this.embeddedPath);
    }

    public String getEmbeddedPath() {
        return this.embeddedPath;
    }

    public Keyword getSearchableKeyword() {
        return Keyword.intern((String)this.searchablePath);
    }

    public String getSearchablePath() {
        return this.searchablePath;
    }

    public String getPropertyName() {
        return this.simpleName;
    }

    public static String getSerializedPropertyKeyword(String namespace, String propertyName) {
        return AbstractMapping.getKeyword(namespace, propertyName + ".json");
    }

    public static String getSearchableValueKeyword(String namespace, String typeName, String propertyName) {
        return AbstractMapping.getKeyword(namespace, typeName + PropertyKeywords.getEndsWithPropertyNameForMatching(propertyName));
    }

    public static String getEndsWithPropertyNameForMatching(String propertyName) {
        return "." + propertyName + ".value";
    }

    public String toString() {
        return "PropertyKeywords{attribute=" + String.valueOf(this.attribute) + ", simpleName='" + this.simpleName + "', embeddedPath='" + this.embeddedPath + "', searchablePath='" + this.searchablePath + "', embeddedKeyword=" + String.valueOf(this.getEmbeddedKeyword()) + ", searchableKeyword=" + String.valueOf(this.getSearchableKeyword()) + ", propertyName='" + this.getPropertyName() + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyKeywords that = (PropertyKeywords)o;
        return Objects.equals(this.attribute, that.attribute) && Objects.equals(this.simpleName, that.simpleName) && Objects.equals(this.embeddedPath, that.embeddedPath) && Objects.equals(this.searchablePath, that.searchablePath);
    }

    public int hashCode() {
        return Objects.hash(this.attribute, this.simpleName, this.embeddedPath, this.searchablePath);
    }
}

