/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.MapEntry;
import clojure.lang.PersistentVector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBAuditCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.Constants;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.InstanceAuditHeaderMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.InstancePropertiesMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import xtdb.api.XtdbDocument;

public class ClassificationMapping
extends InstanceAuditHeaderMapping {
    private static final String NAMESPACE = ClassificationMapping.getKeyword("classifications");
    private static final String CLASSIFICATION = "classification";
    private static final String N_CLASSIFICATION_TYPE = "type";
    private static final String N_CLASSIFICATION_ORIGIN = "classificationOrigin";
    private static final String N_CLASSIFICATION_ORIGIN_GUID = "classificationOriginGUID";
    public static final String CLASSIFICATION_PROPERTIES_NS = "classificationProperties";
    public static final String N_LAST_CLASSIFICATION_CHANGE = "lastClassificationChange";
    public static final String LAST_CLASSIFICATION_CHANGE = ClassificationMapping.getKeyword("lastClassificationChange");
    private static final Set<String> KNOWN_PROPERTIES = ClassificationMapping.createKnownProperties();
    private List<Classification> classifications;
    private XtdbDocument xtdbDoc;

    private static Set<String> createKnownProperties() {
        HashSet<String> set = new HashSet<String>();
        set.add(N_CLASSIFICATION_ORIGIN);
        set.add(N_CLASSIFICATION_ORIGIN_GUID);
        return set;
    }

    public ClassificationMapping(XTDBOMRSRepositoryConnector xtdbConnector, List<Classification> classifications) {
        super(xtdbConnector);
        this.classifications = classifications;
    }

    public ClassificationMapping(XTDBOMRSRepositoryConnector xtdbConnector, XtdbDocument xtdbDoc) {
        super(xtdbConnector);
        this.xtdbDoc = xtdbDoc;
    }

    public static boolean isKnownBaseProperty(String property) {
        return KNOWN_PROPERTIES.contains(property);
    }

    public void addToXtdbDoc(XtdbDocument.Builder builder) {
        if (this.classifications != null) {
            String lastClassificationName = null;
            try {
                Date latestChange = null;
                ArrayList<String> classificationNames = new ArrayList<String>();
                for (Classification classification : this.classifications) {
                    String classificationName;
                    lastClassificationName = classificationName = classification.getName();
                    classificationNames.add(classificationName);
                    String qualifiedNamespace = ClassificationMapping.getNamespaceForClassification(classificationName);
                    Date latestClassification = InstanceAuditHeaderMapping.buildDoc(builder, (InstanceAuditHeader)classification, qualifiedNamespace);
                    if (latestChange == null || latestChange.before(latestClassification)) {
                        latestChange = latestClassification;
                    }
                    builder.put(ClassificationMapping.getKeyword(qualifiedNamespace, N_CLASSIFICATION_ORIGIN_GUID), (Object)classification.getClassificationOriginGUID());
                    builder.put(ClassificationMapping.getKeyword(qualifiedNamespace, N_CLASSIFICATION_ORIGIN), (Object)ClassificationMapping.getSymbolicNameForClassificationOrigin(classification.getClassificationOrigin()));
                    InstancePropertiesMapping.addToDoc(this.xtdbConnector, builder, classification.getType(), classification.getProperties());
                }
                builder.put(NAMESPACE, (Object)PersistentVector.create(classificationNames));
                builder.put(ClassificationMapping.getKeyword(N_LAST_CLASSIFICATION_CHANGE), latestChange);
            }
            catch (IOException e) {
                this.xtdbConnector.logProblem(ClassificationMapping.class.getName(), "addToXtdbDoc", XTDBAuditCode.SERIALIZATION_FAILURE, e, "<unknown>", lastClassificationName, e.getClass().getName());
            }
        }
    }

    public static IPersistentMap addToMap(IPersistentMap doc, Classification classification) throws IOException, InvalidParameterException {
        IPersistentVector classificationNames = (IPersistentVector)doc.valAt((Object)Keyword.intern((String)NAMESPACE));
        String classificationName = classification.getName();
        if (classificationNames == null) {
            classificationNames = PersistentVector.create((Object[])new Object[]{classificationName});
        } else {
            boolean alreadyThere = false;
            for (int i = 0; i < classificationNames.length() && !alreadyThere; ++i) {
                String existingName = (String)classificationNames.nth(i);
                if (!existingName.equals(classificationName)) continue;
                alreadyThere = true;
            }
            if (!alreadyThere) {
                classificationNames = classificationNames.cons((Object)classificationName);
            }
        }
        String qualifiedNamespace = ClassificationMapping.getNamespaceForClassification(classificationName);
        IPersistentVector tuple = InstanceAuditHeaderMapping.addToMap(doc, (InstanceAuditHeader)classification, qualifiedNamespace);
        Date timestamp = (Date)tuple.nth(0);
        doc = (IPersistentMap)tuple.nth(1);
        doc = InstancePropertiesMapping.addToMap(doc, classification.getType().getTypeDefGUID(), classification.getProperties());
        return doc.assoc((Object)Keyword.intern((String)ClassificationMapping.getKeyword(qualifiedNamespace, N_CLASSIFICATION_ORIGIN_GUID)), (Object)classification.getClassificationOriginGUID()).assoc((Object)Keyword.intern((String)ClassificationMapping.getKeyword(qualifiedNamespace, N_CLASSIFICATION_ORIGIN)), (Object)ClassificationMapping.getSymbolicNameForClassificationOrigin(classification.getClassificationOrigin())).assoc((Object)Keyword.intern((String)NAMESPACE), (Object)classificationNames).assoc((Object)Keyword.intern((String)ClassificationMapping.getKeyword(N_LAST_CLASSIFICATION_CHANGE)), (Object)timestamp);
    }

    public static IPersistentMap removeFromMap(IPersistentMap doc, String classificationName) throws ClassificationErrorException {
        String methodName = "removeFromMap";
        IPersistentVector classificationNames = (IPersistentVector)doc.valAt((Object)Keyword.intern((String)NAMESPACE));
        if (classificationNames == null) {
            throw new ClassificationErrorException(XTDBErrorCode.ENTITY_NOT_CLASSIFIED.getMessageDefinition(classificationName, (String)doc.valAt((Object)Constants.XTDB_PK)), ClassificationMapping.class.getName(), "removeFromMap");
        }
        ArrayList<String> newNames = new ArrayList<String>();
        boolean found = false;
        for (int i = 0; i < classificationNames.length() && !found; ++i) {
            String existingName = (String)classificationNames.nth(i);
            if (existingName.equals(classificationName)) {
                found = true;
                continue;
            }
            newNames.add(existingName);
        }
        if (!found) {
            throw new ClassificationErrorException(XTDBErrorCode.ENTITY_NOT_CLASSIFIED.getMessageDefinition(classificationName, (String)doc.valAt((Object)Constants.XTDB_PK)), ClassificationMapping.class.getName(), "removeFromMap");
        }
        classificationNames = PersistentVector.create(newNames);
        String qualifiedNamespace = ClassificationMapping.getNamespaceForClassification(classificationName);
        for (MapEntry entry : doc) {
            Object key = entry.getKey();
            String keyName = key.toString().substring(1);
            if (!keyName.startsWith(qualifiedNamespace)) continue;
            doc = doc.without(key);
        }
        return doc.assoc((Object)Keyword.intern((String)NAMESPACE), (Object)classificationNames).assoc((Object)Keyword.intern((String)ClassificationMapping.getKeyword(N_LAST_CLASSIFICATION_CHANGE)), (Object)new Date());
    }

    public static void validateHasClassification(IPersistentMap instance, String classificationName, String className, String methodName) throws ClassificationErrorException {
        IPersistentVector classificationNames = (IPersistentVector)instance.valAt((Object)Keyword.intern((String)NAMESPACE));
        boolean exists = false;
        if (classificationNames != null) {
            for (int i = 0; i < classificationNames.length() && !exists; ++i) {
                String candidate = (String)classificationNames.nth(i);
                exists = classificationName.equals(candidate);
            }
        }
        if (!exists) {
            String entityGUID = (String)instance.valAt((Object)Constants.XTDB_PK);
            throw new ClassificationErrorException(XTDBErrorCode.ENTITY_NOT_CLASSIFIED.getMessageDefinition(classificationName, entityGUID), className, methodName);
        }
    }

    public List<Classification> toEgeria() {
        if (this.classifications != null) {
            return this.classifications;
        }
        if (this.xtdbDoc == null) {
            return null;
        }
        return this.fromDoc();
    }

    protected List<Classification> fromDoc() {
        ArrayList<Classification> list = new ArrayList<Classification>();
        IPersistentVector classificationNames = (IPersistentVector)this.xtdbDoc.get(NAMESPACE);
        if (classificationNames != null) {
            for (int i = 0; i < classificationNames.length(); ++i) {
                String classificationName = (String)classificationNames.nth(i);
                String namespaceForClassification = ClassificationMapping.getNamespaceForClassification(classificationName);
                Classification classification = new Classification();
                classification.setName(classificationName);
                super.fromDoc((InstanceAuditHeader)classification, this.xtdbDoc, namespaceForClassification);
                IPersistentMap embeddedType = (IPersistentMap)this.xtdbDoc.get(ClassificationMapping.getKeyword(namespaceForClassification, N_CLASSIFICATION_TYPE));
                InstanceType classificationType = (InstanceType)ClassificationMapping.getDeserializedValue(this.xtdbConnector, CLASSIFICATION, N_CLASSIFICATION_TYPE, embeddedType, mapper.getTypeFactory().constructType(InstanceType.class));
                InstanceProperties ip = InstancePropertiesMapping.getFromDoc(this.xtdbConnector, classificationType, this.xtdbDoc);
                if (ip != null) {
                    classification.setProperties(ip);
                }
                String originGuid = (String)this.xtdbDoc.get(ClassificationMapping.getKeyword(namespaceForClassification, N_CLASSIFICATION_ORIGIN_GUID));
                classification.setClassificationOriginGUID(originGuid);
                String originSymbolicName = (String)this.xtdbDoc.get(ClassificationMapping.getKeyword(namespaceForClassification, N_CLASSIFICATION_ORIGIN));
                ClassificationOrigin classificationOrigin = ClassificationMapping.getClassificationOriginFromSymbolicName(this.xtdbConnector, originSymbolicName);
                classification.setClassificationOrigin(classificationOrigin);
                list.add(classification);
            }
        }
        return list.isEmpty() ? null : list;
    }

    public static List<Classification> fromMap(IPersistentMap doc) throws IOException, InvalidParameterException {
        ArrayList<Classification> list = new ArrayList<Classification>();
        IPersistentVector classificationNames = (IPersistentVector)doc.valAt((Object)Keyword.intern((String)NAMESPACE));
        if (classificationNames != null) {
            for (int i = 0; i < classificationNames.length(); ++i) {
                String classificationName = (String)classificationNames.nth(i);
                String namespaceForClassification = ClassificationMapping.getNamespaceForClassification(classificationName);
                Classification classification = new Classification();
                classification.setName(classificationName);
                InstanceAuditHeaderMapping.fromMap((InstanceAuditHeader)classification, doc, namespaceForClassification);
                InstanceType classificationType = ClassificationMapping.getTypeFromInstance(doc, namespaceForClassification);
                InstanceProperties ip = InstancePropertiesMapping.getFromMap(classificationType, doc);
                if (ip != null) {
                    classification.setProperties(ip);
                }
                String originGuid = (String)doc.valAt((Object)Keyword.intern((String)ClassificationMapping.getKeyword(namespaceForClassification, N_CLASSIFICATION_ORIGIN_GUID)));
                classification.setClassificationOriginGUID(originGuid);
                String originSymbolicName = (String)doc.valAt((Object)Keyword.intern((String)ClassificationMapping.getKeyword(namespaceForClassification, N_CLASSIFICATION_ORIGIN)));
                ClassificationOrigin classificationOrigin = ClassificationMapping.getClassificationOriginFromSymbolicName(originSymbolicName);
                classification.setClassificationOrigin(classificationOrigin);
                list.add(classification);
            }
        }
        return list.isEmpty() ? null : list;
    }

    public static String getNamespaceForClassification(String root, String classificationName) {
        return root + "." + classificationName;
    }

    public static String getClassificationNameFromNamespace(String root, String qualifiedNamespace) {
        String remainder = qualifiedNamespace.substring(root.length() + 1);
        if (remainder.contains(".")) {
            int firstDot = remainder.indexOf(".");
            return remainder.substring(0, firstDot);
        }
        return remainder;
    }

    public static String getNamespaceForClassification(String classificationName) {
        return ClassificationMapping.getNamespaceForClassification(NAMESPACE, classificationName);
    }

    public static ClassificationOrigin getClassificationOriginFromSymbolicName(XTDBOMRSRepositoryConnector xtdbConnector, String symbolicName) {
        String methodName = "getClassificationOriginFromSymbolicName";
        for (ClassificationOrigin b : ClassificationOrigin.values()) {
            if (!b.getName().equals(symbolicName)) continue;
            return b;
        }
        xtdbConnector.logProblem(ClassificationMapping.class.getName(), "getClassificationOriginFromSymbolicName", XTDBAuditCode.NON_EXISTENT_ENUM, null, "ClassificationOrigin", symbolicName);
        return null;
    }

    public static ClassificationOrigin getClassificationOriginFromSymbolicName(String symbolicName) throws InvalidParameterException {
        String methodName = "getClassificationOriginFromSymbolicName";
        for (ClassificationOrigin b : ClassificationOrigin.values()) {
            if (!b.getName().equals(symbolicName)) continue;
            return b;
        }
        throw new InvalidParameterException(XTDBErrorCode.UNKNOWN_ENUMERATED_VALUE.getMessageDefinition(symbolicName, "ClassificationOrigin"), ClassificationMapping.class.getName(), "getClassificationOriginFromSymbolicName", "symbolicName");
    }

    public static String getSymbolicNameForClassificationOrigin(ClassificationOrigin co) {
        return co == null ? null : co.getName();
    }

    public static String getNamespaceForProperties(String qualifiedRoot) {
        return qualifiedRoot + ".classificationProperties";
    }
}

