/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.model.search;

import clojure.lang.IPersistentCollection;
import clojure.lang.Keyword;
import clojure.lang.PersistentList;
import clojure.lang.PersistentVector;
import clojure.lang.Symbol;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntitySummaryMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.model.search.ConditionBuilder;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.model.search.XTDBQuery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;

public class XTDBGraphQuery
extends XTDBQuery {
    public static final Symbol RELATIONSHIP = Symbol.intern((String)"r");
    private static final Keyword ENTITY_PROXIES = Keyword.intern((String)RelationshipMapping.ENTITY_PROXIES);

    public void addRelationshipLimiters(String rootEntityGUID, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus) {
        this.addFindElement(RELATIONSHIP);
        this.conditions.add(this.getRelatedToCondition());
        this.conditions.add(this.getRelatedToCondition(EntitySummaryMapping.getReference(rootEntityGUID)));
        if (relationshipTypeGUIDs != null && !relationshipTypeGUIDs.isEmpty()) {
            this.conditions.addAll(this.getTypeCondition(RELATIONSHIP, TypeDefCategory.RELATIONSHIP_DEF, null, relationshipTypeGUIDs));
        }
        this.addStatusLimiters(limitResultsByStatus, RELATIONSHIP);
    }

    public void addEntityLimiters(List<String> entityTypeGUIDs, List<String> limitResultsByClassification, List<InstanceStatus> limitResultsByStatus) {
        if (entityTypeGUIDs != null && !entityTypeGUIDs.isEmpty()) {
            this.conditions.addAll(this.getTypeCondition(DOC_ID, TypeDefCategory.ENTITY_DEF, null, entityTypeGUIDs));
        }
        if (limitResultsByClassification != null && !limitResultsByClassification.isEmpty()) {
            this.conditions.addAll(this.getClassificationConditions(limitResultsByClassification));
        }
        this.addStatusLimiters(limitResultsByStatus, DOC_ID);
    }

    protected List<IPersistentCollection> getClassificationConditions(List<String> limitByClassifications) {
        ArrayList<IPersistentCollection> classificationConditions = new ArrayList<IPersistentCollection>();
        Keyword classificationsRef = Keyword.intern((String)"classifications");
        if (limitByClassifications.size() == 1) {
            classificationConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{DOC_ID, classificationsRef, limitByClassifications.get(0)}));
        } else {
            Symbol setVar = Symbol.intern((String)"cf");
            Symbol classificationVar = Symbol.intern((String)"classification");
            classificationConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{DOC_ID, classificationsRef, classificationVar}));
            ArrayList<Object> set = new ArrayList<Object>();
            set.add(ConditionBuilder.SET_OPERATOR);
            set.addAll(limitByClassifications);
            classificationConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{PersistentList.create(set), setVar}));
            ArrayList<Symbol> contains = new ArrayList<Symbol>();
            contains.add(Symbol.intern((String)"contains?"));
            contains.add(setVar);
            contains.add(classificationVar);
            classificationConditions.add((IPersistentCollection)PersistentVector.create((Object[])new Object[]{PersistentList.create(contains)}));
        }
        return classificationConditions;
    }

    protected PersistentVector getRelatedToCondition() {
        return PersistentVector.create((Object[])new Object[]{RELATIONSHIP, ENTITY_PROXIES, DOC_ID});
    }

    protected PersistentVector getRelatedToCondition(String literal) {
        return PersistentVector.create((Object[])new Object[]{RELATIONSHIP, ENTITY_PROXIES, literal});
    }
}

