/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops;

import clojure.lang.IPersistentMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBAuditCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.InstanceHeaderMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.model.search.XTDBGraphQuery;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops.AbstractReadOperation;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops.GetEntity;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops.GetRelationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.IXtdbDatasource;

public abstract class AbstractGraphOperation
extends AbstractReadOperation {
    private static final Logger log = LoggerFactory.getLogger(AbstractGraphOperation.class);
    protected final String startEntityGUID;
    protected final List<InstanceStatus> limitResultsByStatus;

    protected AbstractGraphOperation(XTDBOMRSRepositoryConnector xtdb, String startEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) {
        super(xtdb, asOfTime);
        this.startEntityGUID = startEntityGUID;
        this.limitResultsByStatus = limitResultsByStatus;
    }

    protected InstanceGraph findNeighborhood(IXtdbDatasource db, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<String> limitResultsByClassification, int level, boolean includeRelationships) throws EntityNotKnownException, RepositoryErrorException {
        String methodName = "findNeighborhood";
        LinkedHashSet consolidated = new LinkedHashSet();
        HashSet<String> entityGUIDsRetrieved = new HashSet<String>();
        HashSet<String> relationshipGUIDsRetrieved = new HashSet<String>();
        HashSet<String> entityGUIDsVisited = new HashSet<String>();
        HashSet<String> relationshipGUIDsVisited = new HashSet<String>();
        List<String> nextEntityGUIDs = new ArrayList<String>();
        nextEntityGUIDs.add(this.startEntityGUID);
        EntitySummary startingEntity = GetEntity.summaryByGuid(this.xtdb, db, this.startEntityGUID);
        if (startingEntity == null) {
            throw new EntityNotKnownException(XTDBErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(this.startEntityGUID), this.getClass().getName(), "findNeighborhood");
        }
        entityGUIDsRetrieved.add(this.startEntityGUID);
        int levelTraversed = 0;
        int totalLevels = level;
        if (totalLevels < 0) {
            totalLevels = 40;
        }
        if (totalLevels > 0) {
            do {
                Set<List<?>> nextGraph = this.getNextLevelNeighbors(db, nextEntityGUIDs, entityTypeGUIDs, relationshipTypeGUIDs, this.limitResultsByStatus, limitResultsByClassification, entityGUIDsVisited, relationshipGUIDsVisited);
                entityGUIDsVisited.addAll(nextEntityGUIDs);
                ++levelTraversed;
                consolidated.addAll(nextGraph);
                nextEntityGUIDs = this.getEntityGUIDsFromGraphResults(nextGraph);
                nextEntityGUIDs.removeAll(entityGUIDsVisited);
            } while (!nextEntityGUIDs.isEmpty() && levelTraversed < totalLevels);
        }
        return this.resultsToGraph(db, consolidated, entityGUIDsRetrieved, relationshipGUIDsRetrieved, includeRelationships);
    }

    protected Set<List<?>> getNextLevelNeighbors(IXtdbDatasource db, List<String> startingPoints, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Set<String> entityGUIDsVisited, Set<String> relationshipGUIDsVisited) throws RepositoryTimeoutException {
        String methodName = "getNextLevelNeighbors";
        LinkedHashSet consolidated = new LinkedHashSet();
        try {
            for (String entityGUID : startingPoints) {
                Collection<List<?>> nextDegree = this.findDirectNeighbors(db, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification);
                log.debug("Found neighborhood results: {}", nextDegree);
                for (List<?> candidateTuple : nextDegree) {
                    String candidateEntityRef = this.getEntityRefFromGraphTuple(candidateTuple);
                    String candidateRelationshipRef = this.getRelationshipRefFromGraphTuple(candidateTuple);
                    String entityGuid = InstanceHeaderMapping.trimGuidFromReference(candidateEntityRef);
                    String relationshipGuid = InstanceHeaderMapping.trimGuidFromReference(candidateRelationshipRef);
                    if (entityGUIDsVisited.contains(entityGuid) && relationshipGUIDsVisited.contains(relationshipGuid)) continue;
                    consolidated.add(candidateTuple);
                    entityGUIDsVisited.add(entityGUID);
                    relationshipGUIDsVisited.add(relationshipGuid);
                }
            }
        }
        catch (TimeoutException e) {
            throw new RepositoryTimeoutException(XTDBErrorCode.QUERY_TIMEOUT.getMessageDefinition(this.xtdb.getRepositoryName()), this.getClass().getName(), "getNextLevelNeighbors", (Exception)e);
        }
        return consolidated;
    }

    protected Collection<List<?>> findDirectNeighbors(IXtdbDatasource db, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification) throws TimeoutException {
        XTDBGraphQuery query = new XTDBGraphQuery();
        query.addRelationshipLimiters(entityGUID, relationshipTypeGUIDs, limitResultsByStatus);
        query.addEntityLimiters(entityTypeGUIDs, limitResultsByClassification, limitResultsByStatus);
        IPersistentMap q = query.getQuery();
        log.debug("Querying with: {}", (Object)q);
        return db.query((Object)q, new Object[0]);
    }

    protected InstanceGraph resultsToGraph(IXtdbDatasource db, Collection<List<?>> xtdbResults, Set<String> entityGUIDsVisited, Set<String> relationshipGUIDsVisited, boolean includeRelationships) {
        String methodName = "resultsToGraph";
        InstanceGraph results = new InstanceGraph();
        ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        try {
            EntityDetail startingEntity = GetEntity.detailByGuid(this.xtdb, db, this.startEntityGUID);
            entities.add(startingEntity);
        }
        catch (EntityProxyOnlyException e) {
            log.debug("Starting entity for traversals was only a proxy, not adding it to results: {}", (Object)this.startEntityGUID);
        }
        entityGUIDsVisited.add(this.startEntityGUID);
        if (xtdbResults != null) {
            for (List<?> xtdbResult : xtdbResults) {
                String relationshipRef;
                String relationshipGuid;
                String entityRef = this.getEntityRefFromGraphTuple(xtdbResult);
                String entityGuid = InstanceHeaderMapping.trimGuidFromReference(entityRef);
                if (!entityGUIDsVisited.contains(entityGuid)) {
                    try {
                        EntityDetail entity = GetEntity.detailByRef(this.xtdb, db, entityRef);
                        if (entity == null) {
                            this.xtdb.logProblem(this.getClass().getName(), "resultsToGraph", XTDBAuditCode.MAPPING_FAILURE, null, "entity", entityRef, "cannot be translated to EntityDetail");
                        } else {
                            entities.add(entity);
                        }
                    }
                    catch (EntityProxyOnlyException e) {
                        log.debug("Found only a proxy in graph traversal, not including in results: {}", (Object)entityGuid);
                    }
                    entityGUIDsVisited.add(entityGuid);
                }
                if (!includeRelationships || relationshipGUIDsVisited.contains(relationshipGuid = InstanceHeaderMapping.trimGuidFromReference(relationshipRef = this.getRelationshipRefFromGraphTuple(xtdbResult)))) continue;
                Relationship relationship = GetRelationship.byRef(this.xtdb, db, relationshipRef);
                relationshipGUIDsVisited.add(relationshipGuid);
                if (relationship == null) {
                    this.xtdb.logProblem(this.getClass().getName(), "resultsToGraph", XTDBAuditCode.MAPPING_FAILURE, null, "relationship", relationshipRef, "cannot be translated to Relationship");
                    continue;
                }
                relationships.add(relationship);
            }
        }
        results.setEntities(entities);
        results.setRelationships(relationships);
        return results;
    }

    private List<String> getEntityGUIDsFromGraphResults(Collection<List<?>> xtdbResults) {
        ArrayList<String> list = new ArrayList<String>();
        for (List<?> result : xtdbResults) {
            String guid;
            String entityRef = this.getEntityRefFromGraphTuple(result);
            if (entityRef == null || list.contains(guid = InstanceHeaderMapping.trimGuidFromReference(entityRef))) continue;
            list.add(guid);
        }
        return list;
    }

    protected String getEntityRefFromGraphTuple(List<?> tuple) {
        return tuple == null ? null : (String)tuple.get(0);
    }

    private String getRelationshipRefFromGraphTuple(List<?> tuple) {
        return tuple == null ? null : (String)tuple.get(1);
    }
}

