/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.Constants;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops.AbstractReadOperation;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import xtdb.api.HistoryOptions;
import xtdb.api.ICursor;
import xtdb.api.IXtdbDatasource;
import xtdb.api.XtdbDocument;

public abstract class AbstractHistoryOperation
extends AbstractReadOperation {
    protected final String instanceGUID;
    protected final Date fromTime;
    protected final int fromElement;
    protected final int pageSize;
    protected final HistorySequencingOrder sequencingOrder;

    protected AbstractHistoryOperation(XTDBOMRSRepositoryConnector xtdb, String instanceGUID, Date fromTime, Date toTime, int fromElement, int pageSize, HistorySequencingOrder sequencingOrder) {
        super(xtdb, toTime);
        this.instanceGUID = instanceGUID;
        this.fromTime = fromTime;
        this.fromElement = fromElement;
        this.pageSize = pageSize;
        this.sequencingOrder = sequencingOrder;
    }

    protected List<XtdbDocument> getPreviousVersions(IXtdbDatasource db, String reference, Date earliest, HistorySequencingOrder order) throws RepositoryErrorException {
        List<XtdbDocument> results;
        String methodName = "getPreviousVersions";
        HistoryOptions options = HistoryOptions.create((HistoryOptions.SortOrder)HistoryOptions.SortOrder.DESC).withDocs(true);
        try (ICursor lazyCursor = db.openEntityHistory((Object)reference, options);){
            results = this.getPreviousVersionsFromCursor(lazyCursor, earliest, order);
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), this.getClass().getName(), "getPreviousVersions", e);
        }
        return results;
    }

    private List<XtdbDocument> getPreviousVersionsFromCursor(ICursor<Map<Keyword, ?>> cursor, Date earliest, HistorySequencingOrder order) {
        ArrayList<XtdbDocument> results = new ArrayList<XtdbDocument>();
        if (cursor != null) {
            while (cursor.hasNext()) {
                Map version = (Map)cursor.next();
                Date versionValidFrom = (Date)version.get(Constants.XTDB_VALID_TIME);
                int comparator = earliest == null ? 1 : versionValidFrom.compareTo(earliest);
                IPersistentMap docVersion = (IPersistentMap)version.get(Constants.XTDB_DOC);
                if (docVersion != null) {
                    results.add(XtdbDocument.factory((IPersistentMap)docVersion));
                }
                if (comparator > 0) continue;
                break;
            }
        }
        if (order.equals((Object)HistorySequencingOrder.FORWARDS)) {
            Collections.reverse(results);
        }
        return results;
    }
}

