/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops.AbstractGraphOperation;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import xtdb.api.IXtdb;
import xtdb.api.IXtdbDatasource;

public class GetEntityNeighborhood
extends AbstractGraphOperation {
    private final List<String> entityTypeGUIDs;
    private final List<String> relationshipTypeGUIDs;
    private final List<String> limitResultsByClassification;
    private final int level;

    public GetEntityNeighborhood(XTDBOMRSRepositoryConnector xtdb, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) {
        super(xtdb, entityGUID, limitResultsByStatus, asOfTime);
        this.entityTypeGUIDs = entityTypeGUIDs;
        this.relationshipTypeGUIDs = relationshipTypeGUIDs;
        this.limitResultsByClassification = limitResultsByClassification;
        this.level = level;
    }

    public InstanceGraph execute() throws EntityNotKnownException, RepositoryErrorException {
        InstanceGraph instanceGraph;
        String methodName = "getEntityNeighborhood";
        IXtdb xtdbAPI = this.xtdb.getXtdbAPI();
        try (IXtdbDatasource db = this.asOfTime == null ? xtdbAPI.openDB() : xtdbAPI.openDB(this.asOfTime);){
            instanceGraph = this.findNeighborhood(db, this.entityTypeGUIDs, this.relationshipTypeGUIDs, this.limitResultsByClassification, this.level, true);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XTDBErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), this.getClass().getName(), "getEntityNeighborhood", (Exception)e);
        }
        return instanceGraph;
    }
}

