/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.readops.AbstractGraphOperation;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import xtdb.api.IXtdb;
import xtdb.api.IXtdbDatasource;

public class GetRelatedEntities
extends AbstractGraphOperation {
    private final List<String> entityTypeGUIDs;
    private final List<String> limitResultsByClassification;

    public GetRelatedEntities(XTDBOMRSRepositoryConnector xtdb, String entityGUID, List<String> entityTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime) {
        super(xtdb, entityGUID, limitResultsByStatus, asOfTime);
        this.entityTypeGUIDs = entityTypeGUIDs;
        this.limitResultsByClassification = limitResultsByClassification;
    }

    public InstanceGraph execute() throws EntityNotKnownException, RepositoryErrorException {
        InstanceGraph instanceGraph;
        String methodName = "getRelatedEntities";
        IXtdb xtdbAPI = this.xtdb.getXtdbAPI();
        try (IXtdbDatasource db = this.asOfTime == null ? xtdbAPI.openDB() : xtdbAPI.openDB(this.asOfTime);){
            instanceGraph = this.findNeighborhood(db, this.entityTypeGUIDs, null, this.limitResultsByClassification, -1, false);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XTDBErrorCode.CANNOT_CLOSE_RESOURCE.getMessageDefinition(), this.getClass().getName(), "getRelatedEntities", (Exception)e);
        }
        return instanceGraph;
    }
}

