/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.PersistentHashMap;
import java.util.Date;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.TypeDefCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.ClassificationMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.InstanceAuditHeaderMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AbstractTransactionFunction;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.ClassifyEntityProxy;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public abstract class ClassifyEntity
extends AbstractTransactionFunction {
    protected final IPersistentMap xtdbDoc;

    protected ClassifyEntity(String className, String methodName, Long txId, PersistentHashMap existing, PersistentHashMap proxy, String userId, String entityGUID, String metadataCollectionId, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties properties) throws Exception {
        try {
            Classification newClassification;
            PersistentHashMap toUpdate;
            if (existing != null) {
                toUpdate = existing;
            } else if (proxy != null) {
                toUpdate = proxy;
            } else {
                throw new EntityNotKnownException(XTDBErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(entityGUID), className, methodName);
            }
            TxnValidations.entityFromStore(entityGUID, (IPersistentMap)toUpdate, className, methodName);
            TxnValidations.instanceIsNotDeleted((IPersistentMap)toUpdate, entityGUID, className, methodName);
            TxnValidations.instanceType((IPersistentMap)toUpdate, className, methodName);
            InstanceType entityType = InstanceAuditHeaderMapping.getTypeFromInstance((IPersistentMap)toUpdate, null);
            TxnValidations.classification(classificationName, entityType.getTypeDefName(), className, methodName);
            String entityTypeDefGUID = ClassifyEntity.getTypeDefGUID((IPersistentMap)toUpdate);
            TypeDef entityTypeDef = TypeDefCache.getTypeDef(entityTypeDefGUID);
            String entityTypeDefName = entityTypeDef.getName();
            try {
                TxnValidations.classificationProperties(classificationName, properties, className, methodName);
                if (externalSourceGUID == null) {
                    newClassification = ClassifyEntity.getNewClassification(metadataCollectionId, null, InstanceProvenanceType.LOCAL_COHORT, userId, classificationName, entityTypeDefName, classificationOrigin == null ? ClassificationOrigin.ASSIGNED : classificationOrigin, classificationOriginGUID, properties);
                } else {
                    newClassification = ClassifyEntity.getNewClassification(externalSourceGUID, externalSourceName, InstanceProvenanceType.EXTERNAL_SOURCE, userId, classificationName, entityTypeDefName, classificationOrigin == null ? ClassificationOrigin.ASSIGNED : classificationOrigin, classificationOriginGUID, properties);
                    newClassification.setMetadataCollectionName(externalSourceName);
                    newClassification.setReplicatedBy(metadataCollectionId);
                }
            }
            catch (TypeErrorException e) {
                throw new ClassificationErrorException(XTDBErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(classificationName, entityTypeDefName), className, methodName, (Exception)((Object)e));
            }
            this.xtdbDoc = ClassificationMapping.addToMap((IPersistentMap)toUpdate, newClassification);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    private static Classification getNewClassification(String metadataCollectionId, String metadataCollectionName, InstanceProvenanceType provenanceType, String userName, String classificationTypeName, String entityTypeName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties properties) throws TypeErrorException {
        String methodName = "getNewClassification";
        if (TypeDefCache.isValidClassificationForEntity(classificationTypeName, entityTypeName)) {
            Classification classification = new Classification();
            classification.setHeaderVersion(1L);
            classification.setInstanceProvenanceType(provenanceType);
            classification.setMetadataCollectionId(metadataCollectionId);
            classification.setMetadataCollectionName(metadataCollectionName);
            classification.setName(classificationTypeName);
            classification.setCreateTime(new Date());
            classification.setCreatedBy(userName);
            classification.setVersion(1L);
            classification.setType(TypeDefCache.getInstanceType(TypeDefCategory.CLASSIFICATION_DEF, classificationTypeName));
            classification.setStatus(TypeDefCache.getInitialStatus(classificationTypeName));
            classification.setClassificationOrigin(classificationOrigin);
            classification.setClassificationOriginGUID(classificationOriginGUID);
            classification.setProperties(properties);
            return classification;
        }
        throw new TypeErrorException(XTDBErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(classificationTypeName, entityTypeName), ClassifyEntityProxy.class.getName(), "getNewClassification");
    }
}

