/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AbstractTransactionFunction;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class PurgeRelationship
extends AbstractTransactionFunction {
    private static final Logger log = LoggerFactory.getLogger(PurgeRelationship.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"purgeRelationship");
    private static final String CLASS_NAME = PurgeRelationship.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx rid force]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db rid)          deleted (.doc (" + PurgeRelationship.class.getCanonicalName() + ". tx-id existing rid force))]         [[:xtdb.api/evict rid]]))";
    private final IPersistentMap xtdbDoc;

    public PurgeRelationship(Long txId, PersistentHashMap existing, String deletedRelationshipGUID, boolean force) throws Exception {
        try {
            if (existing == null) {
                throw new RelationshipNotKnownException(XTDBErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(deletedRelationshipGUID), CLASS_NAME, METHOD_NAME);
            }
            if (!force) {
                TxnValidations.relationshipFromStore(deletedRelationshipGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
                try {
                    TxnValidations.instanceIsDeleted((IPersistentMap)existing, deletedRelationshipGUID, CLASS_NAME, METHOD_NAME);
                }
                catch (InvalidParameterException e) {
                    throw new RelationshipNotDeletedException(XTDBErrorCode.INSTANCE_NOT_DELETED.getMessageDefinition(deletedRelationshipGUID), CLASS_NAME, METHOD_NAME);
                }
            }
            this.xtdbDoc = existing;
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static void transactWithValidation(XTDBOMRSRepositoryConnector xtdb, String relationshipGUID) throws RelationshipNotKnownException, RelationshipNotDeletedException, RepositoryErrorException {
        String docId = RelationshipMapping.getReference(relationshipGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, false});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            xtdb.validateCommit(results, METHOD_NAME);
        }
        catch (RelationshipNotDeletedException | RelationshipNotKnownException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, e);
        }
    }

    public static void transactWithoutValidation(XTDBOMRSRepositoryConnector xtdb, String relationshipGUID) throws RelationshipNotKnownException, RepositoryErrorException {
        String docId = RelationshipMapping.getReference(relationshipGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, true});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            xtdb.validateCommit(results, METHOD_NAME);
        }
        catch (RelationshipNotKnownException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Relationship being purged: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        PurgeRelationship.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

