/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.ReIdentifyInstance;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class ReIdentifyRelationship
extends ReIdentifyInstance {
    private static final Logger log = LoggerFactory.getLogger(ReIdentifyRelationship.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"reIdentifyRelationship");
    private static final String CLASS_NAME = ReIdentifyRelationship.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid user nid mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updates (.tuple (" + ReIdentifyRelationship.class.getCanonicalName() + ". tx-id existing user eid nid mid))]         (vec (for [doc updates]                   (let [" + ReIdentifyRelationship.getTxnTimeCalculation("doc") + "]                        [:xtdb.api/put doc txt])))))";
    private final IPersistentVector xtdbTuple;

    public ReIdentifyRelationship(Long txId, PersistentHashMap existing, String userId, String relationshipGUID, String newRelationshipGUID, String metadataCollectionId) throws Exception {
        try {
            if (existing == null) {
                throw new RelationshipNotKnownException(XTDBErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(relationshipGUID), CLASS_NAME, METHOD_NAME);
            }
            TxnValidations.relationshipFromStore(relationshipGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
            ReIdentifyRelationship.validate((IPersistentMap)existing, relationshipGUID, metadataCollectionId, CLASS_NAME, METHOD_NAME);
            this.xtdbTuple = ReIdentifyRelationship.reIdentifyInstance(userId, (IPersistentMap)existing, relationshipGUID, newRelationshipGUID);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static Relationship transact(XTDBOMRSRepositoryConnector xtdb, String userId, String relationshipGUID, String newRelationshipGUID) throws RelationshipNotKnownException, InvalidParameterException, RepositoryErrorException {
        String docId = RelationshipMapping.getReference(relationshipGUID);
        String newId = RelationshipMapping.getReference(newRelationshipGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId, newId, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            return xtdb.getResultingRelationship(newId, results, METHOD_NAME);
        }
        catch (InvalidParameterException | RelationshipNotKnownException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, e);
        }
    }

    public IPersistentVector tuple() {
        log.debug("Re-identification being persisted: {}", (Object)this.xtdbTuple);
        return this.xtdbTuple;
    }

    public static void create(Transaction.Builder tx) {
        ReIdentifyRelationship.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

