/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityDetailMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.RestoreInstance;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class RestoreEntity
extends RestoreInstance {
    private static final Logger log = LoggerFactory.getLogger(RestoreEntity.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"restoreEntity");
    private static final String CLASS_NAME = RestoreEntity.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid user mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          restored (.doc (" + RestoreEntity.class.getCanonicalName() + ". tx-id existing user eid mid))" + RestoreEntity.getTxnTimeCalculation("restored") + "]         [[:xtdb.api/put restored txt]]))";
    private final IPersistentMap xtdbDoc;

    public RestoreEntity(Long txId, PersistentHashMap existing, String userId, String entityGUID, String metadataCollectionId) throws Exception {
        try {
            if (existing == null) {
                throw new EntityNotKnownException(XTDBErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(entityGUID), this.getClass().getName(), METHOD_NAME);
            }
            TxnValidations.nonProxyEntity((IPersistentMap)existing, entityGUID, CLASS_NAME, METHOD_NAME);
            TxnValidations.entityFromStore(entityGUID, (IPersistentMap)existing, CLASS_NAME, METHOD_NAME);
            try {
                TxnValidations.instanceIsDeleted((IPersistentMap)existing, entityGUID, CLASS_NAME, METHOD_NAME);
            }
            catch (InvalidParameterException e) {
                throw new EntityNotDeletedException(XTDBErrorCode.INSTANCE_NOT_DELETED.getMessageDefinition(entityGUID), CLASS_NAME, METHOD_NAME);
            }
            TxnValidations.instanceCanBeUpdated((IPersistentMap)existing, entityGUID, metadataCollectionId, CLASS_NAME, METHOD_NAME);
            this.xtdbDoc = RestoreEntity.restoreInstance(userId, (IPersistentMap)existing);
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static EntityDetail transact(XTDBOMRSRepositoryConnector xtdb, String userId, String entityGUID) throws EntityNotKnownException, EntityNotDeletedException, InvalidParameterException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entityGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            EntityDetail result = xtdb.getResultingEntity(docId, results, METHOD_NAME);
            OMRSRepositoryValidator repositoryValidator = xtdb.getRepositoryValidator();
            String repositoryName = xtdb.getRepositoryName();
            repositoryValidator.validateEntityFromStore(repositoryName, entityGUID, result, METHOD_NAME);
            repositoryValidator.validateEntityIsNotDeleted(repositoryName, (InstanceHeader)result, METHOD_NAME);
            return result;
        }
        catch (EntityNotDeletedException | EntityNotKnownException | InvalidParameterException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), RestoreEntity.class.getName(), METHOD_NAME, e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        RestoreEntity.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

