/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.ClassificationMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityProxyMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.InstanceAuditHeaderMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AbstractTransactionFunction;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.SaveEntityReferenceCopy;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.TxnValidations;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public abstract class SaveClassificationReferenceCopy
extends AbstractTransactionFunction {
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"saveClassificationReferenceCopy");
    protected final IPersistentMap xtdbDoc;

    protected SaveClassificationReferenceCopy(String className, String methodName, Long txId, String entityGUID, PersistentHashMap existing, PersistentHashMap entity, Classification classification, String homeMetadataCollectionId) throws Exception {
        try {
            PersistentHashMap docToUpdate = null;
            if (homeMetadataCollectionId.equals(classification.getMetadataCollectionId())) {
                throw new PropertyErrorException(XTDBErrorCode.CLASSIFICATION_HOME_COLLECTION_REFERENCE.getMessageDefinition(entityGUID, homeMetadataCollectionId), className, methodName);
            }
            if (existing != null) {
                docToUpdate = existing;
            } else if (!homeMetadataCollectionId.equals(SaveClassificationReferenceCopy.getMetadataCollectionId((IPersistentMap)entity)) || EntityProxyMapping.isOnlyAProxy((IPersistentMap)entity)) {
                docToUpdate = entity;
            }
            if (docToUpdate != null) {
                try {
                    TxnValidations.entityFromStore(entityGUID, (IPersistentMap)docToUpdate, className, methodName);
                    TxnValidations.instanceIsNotDeleted((IPersistentMap)docToUpdate, entityGUID, className, methodName);
                    TxnValidations.instanceType((IPersistentMap)docToUpdate, className, methodName);
                    TxnValidations.classification(classification.getName(), SaveClassificationReferenceCopy.getTypeDefForInstance((IPersistentMap)docToUpdate).getName(), className, methodName);
                    TxnValidations.classificationProperties(classification.getName(), classification.getProperties(), className, methodName);
                    docToUpdate = ClassificationMapping.addToMap((IPersistentMap)docToUpdate, classification);
                }
                catch (ClassificationErrorException | EntityNotKnownException e) {
                    throw new TypeErrorException((OMRSCheckedExceptionBase)e);
                }
            }
            this.xtdbDoc = docToUpdate;
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    protected static String getTxFn(String className) {
        return "(fn [ctx eid e rcc mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updated (.doc (" + className + ". tx-id eid existing e rcc mid))" + SaveClassificationReferenceCopy.getTxnTimeCalculation("updated") + "          nmid (when (some? updated)                     (get updated :" + InstanceAuditHeaderMapping.METADATA_COLLECTION_ID + "))]         (when (some? nmid)          (if (= mid nmid)            [[:xtdb.api/put updated txt]]            [[:xtdb.api/fn " + String.valueOf(SaveEntityReferenceCopy.FUNCTION_NAME) + " eid updated mid]]))))";
    }
}

