/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityDetailMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AbstractTransactionFunction;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.XtdbDocument;
import xtdb.api.tx.Transaction;

public class SaveEntityReferenceCopy
extends AbstractTransactionFunction {
    private static final Logger log = LoggerFactory.getLogger(SaveEntityReferenceCopy.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"saveEntityReferenceCopy");
    private static final String CLASS_NAME = SaveEntityReferenceCopy.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid rce mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updated (.doc (" + SaveEntityReferenceCopy.class.getCanonicalName() + ". tx-id existing rce mid))" + SaveEntityReferenceCopy.getTxnTimeCalculation("updated") + "]         [[:xtdb.api/put updated txt]]))";
    private final IPersistentMap xtdbDoc;

    public SaveEntityReferenceCopy(Long txId, PersistentHashMap existing, PersistentHashMap updated, String homeMetadataCollectionId) throws Exception {
        try {
            String rcMetadataCollectionId = SaveEntityReferenceCopy.getMetadataCollectionId((IPersistentMap)updated);
            if (rcMetadataCollectionId.equals(homeMetadataCollectionId)) {
                throw new HomeEntityException(XTDBErrorCode.ENTITY_HOME_COLLECTION_REFERENCE.getMessageDefinition(SaveEntityReferenceCopy.getGUID((IPersistentMap)updated), homeMetadataCollectionId), CLASS_NAME, METHOD_NAME);
            }
            if (existing == null) {
                this.xtdbDoc = updated;
            } else {
                String exMetadataCollectionId = SaveEntityReferenceCopy.getMetadataCollectionId((IPersistentMap)existing);
                if (!rcMetadataCollectionId.equals(exMetadataCollectionId)) {
                    throw new EntityConflictException(XTDBErrorCode.METADATA_COLLECTION_CONFLICT.getMessageDefinition(SaveEntityReferenceCopy.getGUID((IPersistentMap)updated)), CLASS_NAME, METHOD_NAME);
                }
                this.xtdbDoc = updated;
            }
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static void transact(XTDBOMRSRepositoryConnector xtdb, EntityDetail toSave) throws EntityConflictException, HomeEntityException, InvalidParameterException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(toSave.getGUID());
        EntityDetailMapping edm = new EntityDetailMapping(xtdb, toSave);
        XtdbDocument toSaveXT = edm.toXTDB();
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, toSaveXT.toMap(), xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            xtdb.validateCommit(results, METHOD_NAME);
        }
        catch (EntityConflictException | HomeEntityException | InvalidParameterException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), CLASS_NAME, METHOD_NAME, e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        SaveEntityReferenceCopy.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

