/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.PropertyKeywords;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.TypeDefCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.ClassificationMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.InstanceAuditHeaderMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.AbstractTransactionFunction;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.Keywords;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;

public class TxnValidations {
    public static void entityFromStore(String guid, IPersistentMap entity, String className, String methodName) throws RepositoryErrorException, EntityNotKnownException {
        if (entity == null) {
            throw new EntityNotKnownException(XTDBErrorCode.ENTITY_NOT_KNOWN.getMessageDefinition(guid), className, methodName);
        }
        TxnValidations.validInstance(entity, className, methodName, true);
    }

    public static void relationshipFromStore(String guid, IPersistentMap relationship, String className, String methodName) throws RepositoryErrorException, RelationshipNotKnownException {
        if (relationship == null) {
            throw new RelationshipNotKnownException(XTDBErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(guid), className, methodName);
        }
        TxnValidations.validRelationship(relationship, className, methodName);
    }

    public static void classification(String classificationName, String entityTypeName, String className, String methodName) throws InvalidParameterException, ClassificationErrorException {
        TxnValidations.validateClassificationName(classificationName, entityTypeName, className, methodName);
        if (entityTypeName != null && !TypeDefCache.isValidClassificationForEntity(classificationName, entityTypeName)) {
            throw new ClassificationErrorException(XTDBErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(classificationName, entityTypeName), className, methodName);
        }
    }

    public static void instanceIsNotDeleted(IPersistentMap existing, String instanceGUID, String className, String methodName) throws InvalidParameterException {
        Integer currentStatus = (Integer)existing.valAt((Object)Keywords.CURRENT_STATUS);
        if (currentStatus != null && currentStatus.intValue() == InstanceStatus.DELETED.getOrdinal()) {
            throw new InvalidParameterException(XTDBErrorCode.INSTANCE_ALREADY_DELETED.getMessageDefinition(instanceGUID), className, methodName, "instance");
        }
    }

    public static void instanceIsDeleted(IPersistentMap existing, String instanceGUID, String className, String methodName) throws InvalidParameterException {
        Integer currentStatus = (Integer)existing.valAt((Object)Keywords.CURRENT_STATUS);
        if (currentStatus != null && currentStatus.intValue() != InstanceStatus.DELETED.getOrdinal()) {
            throw new InvalidParameterException(XTDBErrorCode.INSTANCE_NOT_DELETED.getMessageDefinition(instanceGUID), className, methodName, "instance");
        }
    }

    public static void nonProxyEntity(IPersistentMap existing, String entityGUID, String className, String methodName) throws EntityNotKnownException {
        Boolean proxyOnly = (Boolean)existing.valAt((Object)Keywords.ENTITY_PROXY_ONLY_MARKER);
        if (proxyOnly != null && proxyOnly.booleanValue()) {
            throw new EntityNotKnownException(XTDBErrorCode.ENTITY_PROXY_ONLY.getMessageDefinition(entityGUID, null), className, methodName);
        }
    }

    public static void instanceCanBeUpdated(IPersistentMap instance, String guid, String metadataCollectionId, String className, String methodName) throws InvalidParameterException {
        TxnValidations.instanceCanBeUpdated(instance, guid, metadataCollectionId, null, className, methodName);
    }

    public static void instanceCanBeUpdated(IPersistentMap instance, String guid, String metadataCollectionId, String classificationName, String className, String methodName) throws InvalidParameterException {
        Keyword REPLICATED_BY;
        Keyword METADATA_COLLECTION_ID;
        Keyword INSTANCE_PROVENANCE_TYPE;
        boolean updateAllowed = true;
        if (classificationName != null) {
            String namespace = ClassificationMapping.getNamespaceForClassification(classificationName);
            INSTANCE_PROVENANCE_TYPE = Keyword.intern((String)namespace, (String)Keywords.INSTANCE_PROVENANCE_TYPE.getName());
            METADATA_COLLECTION_ID = Keyword.intern((String)namespace, (String)Keywords.METADATA_COLLECTION_ID.getName());
            REPLICATED_BY = Keyword.intern((String)namespace, (String)Keywords.REPLICATED_BY.getName());
        } else {
            INSTANCE_PROVENANCE_TYPE = Keywords.INSTANCE_PROVENANCE_TYPE;
            METADATA_COLLECTION_ID = Keywords.METADATA_COLLECTION_ID;
            REPLICATED_BY = Keywords.REPLICATED_BY;
        }
        Integer instanceProvenance = (Integer)instance.valAt((Object)INSTANCE_PROVENANCE_TYPE);
        if (instanceProvenance != null) {
            if (instanceProvenance.intValue() == InstanceProvenanceType.LOCAL_COHORT.getOrdinal()) {
                String entityHome = (String)instance.valAt((Object)METADATA_COLLECTION_ID);
                if (entityHome != null && !entityHome.equals(metadataCollectionId)) {
                    updateAllowed = false;
                }
            } else if (instanceProvenance.intValue() == InstanceProvenanceType.EXTERNAL_SOURCE.getOrdinal()) {
                String replicatedBy = (String)instance.valAt((Object)REPLICATED_BY);
                if (replicatedBy != null && !replicatedBy.equals(metadataCollectionId)) {
                    updateAllowed = false;
                }
            } else {
                updateAllowed = false;
            }
        } else {
            updateAllowed = false;
        }
        if (!updateAllowed) {
            throw new InvalidParameterException(XTDBErrorCode.INSTANCE_HOME_NOT_LOCAL.getMessageDefinition((String)instance.valAt((Object)Keywords.METADATA_COLLECTION_ID), guid, metadataCollectionId), className, methodName, "instance");
        }
    }

    public static void requiredProperty(String guid, String propertyName, Object propertyValue, String className, String methodName) throws InvalidParameterException {
        if (propertyValue == null) {
            throw new InvalidParameterException(XTDBErrorCode.NULL_REQUIRED_PROPERTY.getMessageDefinition(propertyName, guid), className, methodName, propertyName);
        }
    }

    public static void instanceType(IPersistentMap instance, String className, String methodName) throws RepositoryErrorException, IOException {
        InstanceType instanceType;
        if (instance != null) {
            instanceType = InstanceAuditHeaderMapping.getTypeFromInstance(instance, null);
            if (instanceType == null) {
                throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(AbstractTransactionFunction.getGUID(instance), "type is null", instance.toString()), className, methodName);
            }
        } else {
            throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition("<null>", "instance is null", "<null>"), className, methodName);
        }
        TxnValidations.knownType(instance, instanceType.getTypeDefGUID(), instanceType.getTypeDefName(), className, methodName);
    }

    public static void instanceStatus(Integer instanceStatus, TypeDef typeDef, String className, String methodName) throws StatusNotSupportedException {
        if (typeDef == null) {
            throw new StatusNotSupportedException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), className, methodName);
        }
        String typeDefName = typeDef.getName();
        if (instanceStatus.intValue() == InstanceStatus.DELETED.getOrdinal()) {
            throw new StatusNotSupportedException(XTDBErrorCode.BAD_INSTANCE_STATUS.getMessageDefinition(InstanceStatus.DELETED.getName(), typeDefName), className, methodName);
        }
        List validStatuses = typeDef.getValidInstanceStatusList();
        for (InstanceStatus validStatus : validStatuses) {
            if (instanceStatus.intValue() != validStatus.getOrdinal()) continue;
            return;
        }
        throw new StatusNotSupportedException(XTDBErrorCode.BAD_INSTANCE_STATUS.getMessageDefinition(instanceStatus.toString(), typeDefName), className, methodName);
    }

    private static void knownType(IPersistentMap instance, String typeGUID, String typeName, String className, String methodName) throws RepositoryErrorException {
        AttributeTypeDef attributeTypeDef;
        TxnValidations.validTypeId(instance, typeGUID, typeName, className, methodName);
        TypeDef typeDef = TypeDefCache.getTypeDef(typeGUID);
        if (typeDef == null && (attributeTypeDef = TypeDefCache.getAttributeTypeDef(typeGUID)) == null) {
            throw new RepositoryErrorException(XTDBErrorCode.INACTIVE_INSTANCE_TYPE.getMessageDefinition(AbstractTransactionFunction.getGUID(instance), typeName, typeGUID), className, methodName);
        }
    }

    public static void classificationProperties(String classificationName, InstanceProperties classificationProperties, String className, String methodName) throws PropertyErrorException, RepositoryErrorException {
        TypeDef classificationTypeDef = TypeDefCache.getTypeDefByName(classificationName);
        if (classificationTypeDef == null) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), className, methodName);
        }
        TxnValidations.propertiesForType(classificationTypeDef, classificationProperties, className, methodName);
    }

    public static void classificationList(IPersistentMap instance, String entityTypeName, String className, String methodName) throws InvalidParameterException, ClassificationErrorException, PropertyErrorException, RepositoryErrorException, IOException {
        List<Classification> classifications = ClassificationMapping.fromMap(instance);
        if (classifications != null) {
            for (Classification classification : classifications) {
                if (classification != null) {
                    TxnValidations.classification(classification.getName(), entityTypeName, className, methodName);
                    TxnValidations.propertiesForType(TypeDefCache.getTypeDefByName(classification.getName()), classification.getProperties(), className, methodName);
                    continue;
                }
                throw new InvalidParameterException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(AbstractTransactionFunction.getGUID(instance), "null classification name", instance.toString()), className, methodName, "classificationName");
            }
        }
    }

    private static void validRelationship(IPersistentMap relationship, String className, String methodName) throws RepositoryErrorException {
        TxnValidations.validInstance(relationship, className, methodName, false);
        IPersistentVector proxies = (IPersistentVector)relationship.valAt((Object)Keywords.ENTITY_PROXIES);
        if (proxies == null || proxies.length() != 2) {
            throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(AbstractTransactionFunction.getGUID(relationship), "one or both ends are null", relationship.toString()), className, methodName);
        }
    }

    private static void validInstance(IPersistentMap instance, String className, String methodName, boolean fromStore) throws RepositoryErrorException {
        String homeMetadataCollectionId;
        InstanceType instanceType;
        if (instance == null) {
            throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition("<null>", "instance is null", "<null>"), className, methodName);
        }
        try {
            instanceType = InstanceAuditHeaderMapping.getTypeFromInstance(instance, null);
        }
        catch (IOException e) {
            throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(AbstractTransactionFunction.getGUID(instance), "type cannot be deserialized", instance.toString()), className, methodName, (Exception)e);
        }
        if (instanceType == null) {
            throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(AbstractTransactionFunction.getGUID(instance), "type is null", instance.toString()), className, methodName);
        }
        TxnValidations.validInstanceId(instance, instanceType.getTypeDefGUID(), instanceType.getTypeDefName(), instanceType.getTypeDefCategory(), className, methodName);
        if (!fromStore && (homeMetadataCollectionId = AbstractTransactionFunction.getMetadataCollectionId(instance)) == null) {
            throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(AbstractTransactionFunction.getGUID(instance), "metadataCollectionId is null", instance.toString()), className, methodName);
        }
    }

    private static void validInstanceId(IPersistentMap instance, String typeDefGUID, String typeDefName, TypeDefCategory category, String className, String methodName) throws RepositoryErrorException {
        TxnValidations.validTypeDefId(instance, typeDefGUID, typeDefName, category, className, methodName);
        if (AbstractTransactionFunction.getGUID(instance) == null) {
            throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition("<null>", "GUID is null", "<null>"), className, methodName);
        }
    }

    private static void validTypeDefId(IPersistentMap instance, String typeDefGUID, String typeDefName, TypeDefCategory category, String className, String methodName) throws RepositoryErrorException {
        TxnValidations.validTypeId(instance, typeDefGUID, typeDefName, className, methodName);
        if (category == null) {
            throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(AbstractTransactionFunction.getGUID(instance), "typeDefCategory is null", instance.toString()), className, methodName);
        }
        TypeDef typeDef = TypeDefCache.getTypeDef(typeDefGUID);
        if (typeDef != null) {
            TypeDefCategory knownTypeDefCategory = typeDef.getCategory();
            if (category.getOrdinal() != knownTypeDefCategory.getOrdinal()) {
                throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(AbstractTransactionFunction.getGUID(instance), "typeDefCategory is unknown", instance.toString()), className, methodName);
            }
        }
    }

    private static void validTypeId(IPersistentMap instance, String typeGUID, String typeName, String className, String methodName) throws RepositoryErrorException {
        if (typeName == null) {
            throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(AbstractTransactionFunction.getGUID(instance), "typeDefName is null", instance.toString()), className, methodName);
        }
        if (typeGUID == null) {
            throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(AbstractTransactionFunction.getGUID(instance), "typeDefGUID is null", instance.toString()), className, methodName);
        }
        TypeDef typeDef = TypeDefCache.getTypeDef(typeGUID);
        if (typeDef != null) {
            if (!typeGUID.equals(typeDef.getGUID())) {
                throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(AbstractTransactionFunction.getGUID(instance), "typeDefGUID does not match", instance.toString()), className, methodName);
            }
        } else {
            AttributeTypeDef attributeTypeDef = TypeDefCache.getAttributeTypeDef(typeGUID);
            if (attributeTypeDef == null) {
                throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(AbstractTransactionFunction.getGUID(instance), "typeDef is unknown", instance.toString()), className, methodName);
            }
            if (!typeGUID.equals(attributeTypeDef.getGUID())) {
                throw new RepositoryErrorException(XTDBErrorCode.INVALID_INSTANCE_FROM_STORE.getMessageDefinition(AbstractTransactionFunction.getGUID(instance), "attributeTypeDefGUID does not match", instance.toString()), className, methodName);
            }
        }
    }

    public static void propertiesForType(TypeDef typeDef, InstanceProperties properties, String className, String methodName) throws RepositoryErrorException, PropertyErrorException {
        Map<String, PropertyKeywords> propertyKeywords;
        if (properties == null || properties.getInstanceProperties() == null || properties.getInstanceProperties().isEmpty()) {
            return;
        }
        if (typeDef == null) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), className, methodName);
        }
        String typeDefCategoryName = null;
        String typeDefName = typeDef.getName();
        if (typeDef.getCategory() != null) {
            typeDefCategoryName = typeDef.getCategory().getName();
        }
        if ((propertyKeywords = TypeDefCache.getAllPropertyKeywordsForTypeDef(typeDef.getGUID())).isEmpty()) {
            throw new PropertyErrorException(XTDBErrorCode.NO_PROPERTIES_FOR_TYPE.getMessageDefinition(typeDefCategoryName, typeDefName), className, methodName);
        }
        Iterator propertyList = properties.getPropertyNames();
        while (propertyList.hasNext()) {
            InstancePropertyValue propertyValue;
            String propertyName = propertyList.next().toString();
            if (propertyName == null) {
                throw new PropertyErrorException(XTDBErrorCode.NULL_PROPERTY_NAME_FOR_INSTANCE.getMessageDefinition(), className, methodName);
            }
            if (!propertyKeywords.containsKey(propertyName)) {
                throw new PropertyErrorException(XTDBErrorCode.BAD_PROPERTY_FOR_TYPE.getMessageDefinition(propertyName, typeDefCategoryName, typeDefName), className, methodName);
            }
            TypeDefAttribute typeDefAttribute = propertyKeywords.get(propertyName).getAttribute();
            AttributeTypeDefCategory propertyDefinitionType = AttributeTypeDefCategory.UNKNOWN_DEF;
            AttributeTypeDef attributeTypeDef = typeDefAttribute.getAttributeType();
            if (attributeTypeDef != null) {
                propertyDefinitionType = attributeTypeDef.getCategory();
            }
            if ((propertyValue = properties.getPropertyValue(propertyName)) == null) {
                throw new PropertyErrorException(XTDBErrorCode.NULL_PROPERTY_VALUE_FOR_INSTANCE.getMessageDefinition(propertyName), className, methodName);
            }
            InstancePropertyCategory propertyType = propertyValue.getInstancePropertyCategory();
            if (propertyType == null) {
                throw new PropertyErrorException(XTDBErrorCode.NULL_PROPERTY_TYPE_FOR_INSTANCE.getMessageDefinition(propertyName), className, methodName);
            }
            boolean validPropertyType = false;
            String actualPropertyTypeName = propertyType.getName();
            String validPropertyTypeName = propertyDefinitionType.getName();
            switch (propertyType) {
                case PRIMITIVE: {
                    if (propertyDefinitionType == AttributeTypeDefCategory.PRIMITIVE) {
                        PrimitiveDef expectedAttributeDef;
                        PrimitiveDefCategory expectedAttributeDefCategory;
                        PrimitivePropertyValue primPropertyValue = (PrimitivePropertyValue)propertyValue;
                        PrimitiveDefCategory primPropertyCategory = primPropertyValue.getPrimitiveDefCategory();
                        if (primPropertyCategory == (expectedAttributeDefCategory = (expectedAttributeDef = (PrimitiveDef)attributeTypeDef).getPrimitiveDefCategory())) {
                            validPropertyType = true;
                            break;
                        }
                        actualPropertyTypeName = primPropertyCategory.getName();
                        validPropertyTypeName = expectedAttributeDefCategory.getName();
                        break;
                    }
                    if (propertyDefinitionType != AttributeTypeDefCategory.UNKNOWN_DEF) break;
                    validPropertyType = true;
                    break;
                }
                case ENUM: {
                    if (propertyDefinitionType != AttributeTypeDefCategory.ENUM_DEF) break;
                    validPropertyType = true;
                    break;
                }
                case MAP: 
                case STRUCT: 
                case ARRAY: {
                    if (propertyDefinitionType != AttributeTypeDefCategory.COLLECTION) break;
                    validPropertyType = true;
                    break;
                }
            }
            if (validPropertyType) continue;
            throw new PropertyErrorException(XTDBErrorCode.BAD_PROPERTY_TYPE.getMessageDefinition(propertyName, actualPropertyTypeName, typeDefCategoryName, typeDefName, validPropertyTypeName), className, methodName);
        }
    }

    private static void validateClassificationName(String classificationName, String entityTypeName, String className, String methodName) throws InvalidParameterException {
        if (classificationName == null) {
            throw new InvalidParameterException(XTDBErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition("<null>", entityTypeName), className, methodName, "classificationName");
        }
        if (TypeDefCache.getTypeDefByName(classificationName) == null) {
            throw new InvalidParameterException(XTDBErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(classificationName, entityTypeName), className, methodName, "classificationName");
        }
    }

    public static void relationshipEnds(String entityOneGUID, String entityTwoGUID, IPersistentMap entityOneProxy, IPersistentMap entityTwoProxy, String typeDefGUID, String className, String methodName) throws InvalidParameterException, RepositoryErrorException {
        TypeDef typeDef = TypeDefCache.getTypeDef(typeDefGUID);
        if (entityOneProxy != null && entityTwoProxy != null && typeDef != null) {
            try {
                RelationshipDef relationshipDef = (RelationshipDef)typeDef;
                TypeDefLink entityOneTypeDef = null;
                TypeDefLink entityTwoTypeDef = null;
                String entityOneTypeDefName = null;
                String entityTwoTypeDefName = null;
                String entityOneTypeName = null;
                String entityTwoTypeName = null;
                RelationshipEndDef entityOneEndDef = relationshipDef.getEndDef1();
                RelationshipEndDef entityTwoEndDef = relationshipDef.getEndDef2();
                if (entityOneEndDef != null && entityTwoEndDef != null) {
                    entityOneTypeDef = entityOneEndDef.getEntityType();
                    entityTwoTypeDef = entityTwoEndDef.getEntityType();
                }
                if (entityOneTypeDef != null && entityTwoTypeDef != null) {
                    entityOneTypeDefName = entityOneTypeDef.getName();
                    entityTwoTypeDefName = entityTwoTypeDef.getName();
                }
                InstanceType entityOneType = InstanceAuditHeaderMapping.getTypeFromInstance(entityOneProxy, null);
                InstanceType entityTwoType = InstanceAuditHeaderMapping.getTypeFromInstance(entityTwoProxy, null);
                if (entityOneType != null && entityTwoType != null) {
                    entityOneTypeName = entityOneType.getTypeDefName();
                    entityTwoTypeName = entityTwoType.getTypeDefName();
                }
                if (TypeDefCache.isTypeOf(entityOneTypeName, entityOneTypeDefName) && TypeDefCache.isTypeOf(entityTwoTypeName, entityTwoTypeDefName)) {
                    return;
                }
                throw new InvalidParameterException(XTDBErrorCode.INVALID_RELATIONSHIP_ENDS.getMessageDefinition(typeDef.getName(), entityOneGUID, entityOneTypeName, entityOneTypeDefName, entityTwoGUID, entityTwoTypeName, entityTwoTypeDefName), className, methodName, "relationship.End");
            }
            catch (InvalidParameterException error) {
                throw error;
            }
            catch (Exception error) {
                throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), className, methodName, error);
            }
        }
        throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), className, methodName);
    }
}

