/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.Keyword;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.cache.ErrorMessageCache;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.RelationshipMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.Keywords;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.TxnValidations;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UndoInstanceUpdate;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.ICursor;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class UndoRelationshipUpdate
extends UndoInstanceUpdate {
    private static final Logger log = LoggerFactory.getLogger(UndoRelationshipUpdate.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"undoRelationshipUpdate");
    private static final String CLASS_NAME = UndoRelationshipUpdate.class.getName();
    private static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx rid user mid]     (with-open [history (xtdb.api/open-entity-history (xtdb.api/db ctx) rid :desc {:with-docs? true})]      (let [tx-id (:xtdb.api/tx-id (xtdb.api/indexing-tx ctx))            updated (.doc (" + UndoRelationshipUpdate.class.getCanonicalName() + ". tx-id history user rid mid))" + UndoRelationshipUpdate.getTxnTimeCalculation("updated") + "]           [[:xtdb.api/put updated txt]])))";
    private final IPersistentMap xtdbDoc;

    public UndoRelationshipUpdate(Long txId, ICursor<IPersistentMap> cursor, String userId, String relationshipGUID, String metadataCollectionId) throws Exception {
        try {
            IPersistentVector history = UndoRelationshipUpdate.getPreviousVersionFromCursor(cursor);
            if (history.length() == 0) {
                throw new RelationshipNotKnownException(XTDBErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(relationshipGUID), this.getClass().getName(), METHOD_NAME);
            }
            IPersistentMap current = (IPersistentMap)history.nth(0);
            if (current == null) {
                throw new RelationshipNotKnownException(XTDBErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(relationshipGUID), this.getClass().getName(), METHOD_NAME);
            }
            if (history.length() == 2) {
                IPersistentMap previous = (IPersistentMap)history.nth(1);
                TxnValidations.instanceCanBeUpdated(current, relationshipGUID, metadataCollectionId, CLASS_NAME, METHOD_NAME);
                this.xtdbDoc = UndoRelationshipUpdate.rollbackRelationship(userId, current, previous);
            } else {
                this.xtdbDoc = current;
            }
        }
        catch (Exception e) {
            throw ErrorMessageCache.add(txId, e);
        }
    }

    public static Relationship transact(XTDBOMRSRepositoryConnector xtdb, String userId, String relationshipGUID) throws RelationshipNotKnownException, InvalidParameterException, RepositoryErrorException {
        String docId = RelationshipMapping.getReference(relationshipGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            Relationship result = xtdb.getResultingRelationship(docId, results, METHOD_NAME);
            OMRSRepositoryValidator repositoryValidator = xtdb.getRepositoryValidator();
            String repositoryName = xtdb.getRepositoryName();
            repositoryValidator.validateRelationshipFromStore(repositoryName, relationshipGUID, result, METHOD_NAME);
            repositoryValidator.validateRelationshipIsNotDeleted(repositoryName, (InstanceHeader)result, METHOD_NAME);
            return result;
        }
        catch (InvalidParameterException | RelationshipNotKnownException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), UndoRelationshipUpdate.class.getName(), METHOD_NAME, e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Relationship being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        UndoRelationshipUpdate.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }

    public static IPersistentMap rollbackRelationship(String userId, IPersistentMap current, IPersistentMap previous) {
        Long currentVersion = (Long)current.valAt((Object)Keywords.VERSION);
        IPersistentMap doc = UndoRelationshipUpdate.incrementVersion(userId, previous);
        doc = doc.assoc((Object)Keywords.VERSION, (Object)(currentVersion + 1L));
        return doc;
    }
}

