/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityDetailMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UpdateEntityClassification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.tx.Transaction;

public class UpdateEntityDetailClassification
extends UpdateEntityClassification {
    private static final Logger log = LoggerFactory.getLogger(UpdateEntityDetailClassification.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"updateEntityDetailClassification");
    public static final String CLASS_NAME = UpdateEntityDetailClassification.class.getName();
    public static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid user cname properties mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updated (.doc (" + UpdateEntityDetailClassification.class.getCanonicalName() + ". tx-id existing user eid mid cname properties))" + UpdateEntityDetailClassification.getTxnTimeCalculation("updated") + "]         [[:xtdb.api/put updated txt]]))";

    public UpdateEntityDetailClassification(Long txId, PersistentHashMap existing, String userId, String entityGUID, String metadataCollectionId, String classificationName, InstanceProperties properties) throws Exception {
        super(CLASS_NAME, METHOD_NAME, txId, existing, null, userId, entityGUID, metadataCollectionId, classificationName, properties);
    }

    public static EntityDetail transact(XTDBOMRSRepositoryConnector xtdb, String userId, String entityGUID, String classificationName, InstanceProperties properties) throws EntityNotKnownException, ClassificationErrorException, InvalidParameterException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entityGUID);
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId, classificationName, properties, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            return xtdb.getResultingEntity(docId, results, METHOD_NAME);
        }
        catch (ClassificationErrorException | EntityNotKnownException | InvalidParameterException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), UpdateEntityDetailClassification.class.getName(), METHOD_NAME, e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        UpdateEntityDetailClassification.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

