/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.XTDBOMRSRepositoryConnector;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.ffdc.XTDBErrorCode;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityDetailMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.mapping.EntityProxyMapping;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.ClassifyEntityProxy;
import org.odpi.openmetadata.adapters.repositoryservices.xtdb.repositoryconnector.txnfn.UpdateEntityClassification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtdb.api.TransactionInstant;
import xtdb.api.XtdbDocument;
import xtdb.api.tx.Transaction;

public class UpdateEntityProxyClassification
extends UpdateEntityClassification {
    private static final Logger log = LoggerFactory.getLogger(UpdateEntityProxyClassification.class);
    public static final Keyword FUNCTION_NAME = Keyword.intern((String)"egeria", (String)"updateEntityProxyClassification");
    public static final String CLASS_NAME = UpdateEntityProxyClassification.class.getName();
    public static final String METHOD_NAME = FUNCTION_NAME.toString();
    private static final String FN = "(fn [ctx eid user pxy cname properties mid]     (let [db (xtdb.api/db ctx)          tx-id (:tx-id db)          existing (xtdb.api/entity db eid)          updated (.doc (" + UpdateEntityProxyClassification.class.getCanonicalName() + ". tx-id existing pxy user eid mid cname properties))" + UpdateEntityProxyClassification.getTxnTimeCalculation("updated") + "]         [[:xtdb.api/put updated txt]]))";

    public UpdateEntityProxyClassification(Long txId, PersistentHashMap existing, PersistentHashMap proxy, String userId, String entityGUID, String metadataCollectionId, String classificationName, InstanceProperties properties) throws Exception {
        super(CLASS_NAME, METHOD_NAME, txId, existing, proxy, userId, entityGUID, metadataCollectionId, classificationName, properties);
    }

    public static Classification transact(XTDBOMRSRepositoryConnector xtdb, String userId, EntityProxy entityProxy, String classificationName, InstanceProperties properties) throws EntityNotKnownException, ClassificationErrorException, InvalidParameterException, PropertyErrorException, RepositoryErrorException {
        String docId = EntityDetailMapping.getReference(entityProxy.getGUID());
        EntityProxyMapping epm = new EntityProxyMapping(xtdb, entityProxy);
        XtdbDocument epXT = epm.toXTDB();
        Transaction.Builder tx = Transaction.builder();
        tx.invokeFunction((Object)FUNCTION_NAME, new Object[]{docId, userId, epXT.toMap(), classificationName, properties, xtdb.getMetadataCollectionId()});
        TransactionInstant results = xtdb.runTx(tx.build());
        try {
            EntitySummary result = xtdb.getResultingEntitySummary(docId, results, METHOD_NAME);
            if (result != null) {
                for (Classification cls : result.getClassifications()) {
                    if (!cls.getName().equals(classificationName)) continue;
                    return cls;
                }
            }
            return null;
        }
        catch (ClassificationErrorException | InvalidParameterException | PropertyErrorException | RepositoryErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryErrorException(XTDBErrorCode.UNKNOWN_RUNTIME_ERROR.getMessageDefinition(), ClassifyEntityProxy.class.getName(), METHOD_NAME, e);
        }
    }

    public IPersistentMap doc() {
        log.debug("Entity being persisted: {}", (Object)this.xtdbDoc);
        return this.xtdbDoc;
    }

    public static void create(Transaction.Builder tx) {
        UpdateEntityProxyClassification.createTransactionFunction(tx, FUNCTION_NAME, FN);
    }
}

