/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.secretsstore.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import org.odpi.openmetadata.adapters.connectors.secretsstore.yaml.ffdc.YAMLAuditCode;
import org.odpi.openmetadata.adapters.connectors.secretsstore.yaml.secretsstore.SecretsCollection;
import org.odpi.openmetadata.adapters.connectors.secretsstore.yaml.secretsstore.SecretsStore;
import org.odpi.openmetadata.adapters.connectors.secretsstore.yaml.secretsstore.TokenAPI;
import org.odpi.openmetadata.frameworks.connectors.SecretsStoreConnector;
import org.odpi.openmetadata.frameworks.connectors.controls.SecretsStoreCollectionProperty;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;

public class YAMLSecretsStoreConnector
extends SecretsStoreConnector {
    private static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private File secretsStoreFile = null;
    private SecretsStore secretsStore = null;

    public void start() throws ConnectorCheckedException {
        super.start();
        this.secretsStoreFile = new File(this.connectionProperties.getEndpoint().getAddress());
        this.refreshSecrets();
    }

    public long getRefreshTimeInterval() throws ConnectorCheckedException {
        SecretsCollection secretsCollection;
        super.checkSecretsStillValid();
        if (this.secretsStore != null && (secretsCollection = this.secretsStore.getSecretsCollections().get(this.secretsCollectionName)) != null) {
            return secretsCollection.getRefreshTimeInterval();
        }
        return 0L;
    }

    public String getSecret(String secretName) {
        SecretsCollection secretsCollection;
        super.checkSecretsStillValid();
        if (this.secretsStore != null && (secretsCollection = this.secretsStore.getSecretsCollections().get(this.secretsCollectionName)) != null) {
            String token;
            if (secretsCollection.getSecrets().get(secretName) != null) {
                return secretsCollection.getSecrets().get(secretName);
            }
            if (SecretsStoreCollectionProperty.TOKEN.getName().equals(secretName) && secretsCollection.getTokenAPI() != null && (token = this.getToken(secretsCollection.getTokenAPI())) != null) {
                secretsCollection.getSecrets().put(SecretsStoreCollectionProperty.TOKEN.getName(), token);
            }
        }
        return null;
    }

    private String getToken(TokenAPI tokenAPI) {
        return "token value";
    }

    protected void refreshSecrets() {
        block2: {
            String methodName = "refreshSecrets";
            try {
                this.secretsStore = (SecretsStore)objectMapper.readValue(this.secretsStoreFile, SecretsStore.class);
            }
            catch (Exception error) {
                if (this.auditLog == null) break block2;
                this.auditLog.logMessage("refreshSecrets", YAMLAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(error.getClass().getName(), "refreshSecrets", error.getMessage()));
            }
        }
    }
}

