/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.secretsstore.yaml;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.secretsstore.yaml.ffdc.YAMLAuditCode;
import org.odpi.openmetadata.adapters.connectors.secretsstore.yaml.secretsstore.SecretsCollection;
import org.odpi.openmetadata.adapters.connectors.secretsstore.yaml.secretsstore.SecretsStore;
import org.odpi.openmetadata.adapters.connectors.secretsstore.yaml.secretsstore.TokenAPI;
import org.odpi.openmetadata.frameworks.connectors.SecretsStoreConnector;
import org.odpi.openmetadata.frameworks.connectors.controls.SecretsStoreCollectionProperty;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.users.NamedList;
import org.odpi.openmetadata.frameworks.connectors.properties.users.UserAccount;

public class YAMLSecretsStoreConnector
extends SecretsStoreConnector {
    private static final ObjectMapper yamlObjectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final ObjectMapper jsonObjectMapper = new ObjectMapper();
    private File secretsStoreFile = null;
    private SecretsStore secretsStore = null;

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        this.secretsStoreFile = new File(connectionProperties.getEndpoint().getAddress());
    }

    public long getRefreshTimeInterval() {
        SecretsCollection secretsCollection;
        if (this.secretsStore != null && (secretsCollection = this.secretsStore.getSecretsCollections().get(this.secretsCollectionName)) != null) {
            return secretsCollection.getRefreshTimeInterval();
        }
        return 0L;
    }

    public String getSecret(String secretName) throws ConnectorCheckedException {
        SecretsCollection secretsCollection;
        super.checkSecretsStillValid();
        if (this.secretsStore != null && this.secretsCollectionName != null && (secretsCollection = this.secretsStore.getSecretsCollections().get(this.secretsCollectionName)) != null) {
            String token;
            if (secretsCollection.getSecrets() != null && secretsCollection.getSecrets().get(secretName) != null) {
                return secretsCollection.getSecrets().get(secretName);
            }
            if (SecretsStoreCollectionProperty.TOKEN.getName().equals(secretName) && secretsCollection.getTokenAPI() != null && (token = this.getToken(secretsCollection.getTokenAPI())) != null) {
                secretsCollection.getSecrets().put(SecretsStoreCollectionProperty.TOKEN.getName(), token);
            }
        }
        return null;
    }

    public NamedList getNamedList(String listName) throws ConnectorCheckedException {
        SecretsCollection secretsCollection;
        super.checkSecretsStillValid();
        if (this.secretsStore != null && (secretsCollection = this.secretsStore.getSecretsCollections().get(this.secretsCollectionName)) != null && secretsCollection.getUsers() != null) {
            return secretsCollection.getNamedLists().get(listName);
        }
        return null;
    }

    public Map<String, NamedList> getNamedLists() throws ConnectorCheckedException {
        SecretsCollection secretsCollection;
        super.checkSecretsStillValid();
        if (this.secretsStore != null && (secretsCollection = this.secretsStore.getSecretsCollections().get(this.secretsCollectionName)) != null) {
            return secretsCollection.getNamedLists();
        }
        return null;
    }

    public UserAccount getUser(String userId) throws ConnectorCheckedException {
        SecretsCollection secretsCollection;
        super.checkSecretsStillValid();
        if (this.secretsStore != null && (secretsCollection = this.secretsStore.getSecretsCollections().get(this.secretsCollectionName)) != null && secretsCollection.getUsers() != null) {
            return secretsCollection.getUsers().get(userId);
        }
        return null;
    }

    public Map<String, UserAccount> getUsers() throws ConnectorCheckedException {
        SecretsCollection secretsCollection;
        super.checkSecretsStillValid();
        if (this.secretsStore != null && (secretsCollection = this.secretsStore.getSecretsCollections().get(this.secretsCollectionName)) != null) {
            return secretsCollection.getUsers();
        }
        return null;
    }

    private String getToken(TokenAPI tokenAPI) {
        String methodName = "getToken";
        if (tokenAPI != null) {
            String contentType = "application/json";
            if (tokenAPI.getContentType() != null) {
                contentType = tokenAPI.getContentType();
            }
            if (tokenAPI.getRequestBody() != null) {
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(tokenAPI.getURL())).header("Content-Type", contentType).method(tokenAPI.getHttpRequestType(), this.buildRequestBody(contentType, tokenAPI.getRequestBody())).build();
                try {
                    HttpResponse<String> response = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
                    System.out.println(response.statusCode());
                    System.out.println(response.body());
                    if (response.statusCode() == 200) {
                        return this.getTokenFromResponseBody(response.body(), tokenAPI.getResponseBodyMapping());
                    }
                }
                catch (Exception error) {
                    super.logExceptionRecord("getToken", YAMLAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(error.getClass().getName(), "getToken", error.getMessage()), (Throwable)error);
                    return null;
                }
            }
        }
        return null;
    }

    private HttpRequest.BodyPublisher buildRequestBody(String contentType, Map<String, Object> requestBodyParameters) {
        if ("application/json".equals(contentType)) {
            return this.ofJSON(requestBodyParameters);
        }
        if ("application/x-www-form-urlencoded".equals(contentType)) {
            return this.ofForm(requestBodyParameters);
        }
        return null;
    }

    public HttpRequest.BodyPublisher ofForm(Map<String, Object> data) {
        if (data != null) {
            StringBuilder body = new StringBuilder();
            for (String dataKey : data.keySet()) {
                if (!body.isEmpty()) {
                    body.append("&");
                }
                body.append(this.encode(dataKey)).append("=").append(this.encode(data.get(dataKey)));
            }
            return HttpRequest.BodyPublishers.ofString(body.toString());
        }
        return null;
    }

    public HttpRequest.BodyPublisher ofJSON(Map<String, Object> data) {
        if (data != null) {
            StringBuilder body = new StringBuilder();
            for (String dataKey : data.keySet()) {
                if (!body.isEmpty()) {
                    body.append(",");
                } else {
                    body.append("{");
                }
                body.append("\"").append(this.encode(dataKey)).append("\"=\"").append(this.encode(data.get(dataKey))).append("\"");
            }
            if (!body.isEmpty()) {
                body.append("}");
                return HttpRequest.BodyPublishers.ofString(body.toString());
            }
        }
        return null;
    }

    private String encode(Object obj) {
        return URLEncoder.encode(obj.toString(), StandardCharsets.UTF_8);
    }

    private String getTokenFromResponseBody(String responseBody, Map<String, String> responseBodyMapping) {
        String methodName = "getTokenFromResponseBody";
        if (responseBodyMapping == null || responseBodyMapping.isEmpty()) {
            return responseBody;
        }
        String tokenVariableName = responseBodyMapping.get(SecretsStoreCollectionProperty.TOKEN.getName());
        if (tokenVariableName != null) {
            try {
                HashMap responseBodyValues = (HashMap)jsonObjectMapper.readValue(responseBody, HashMap.class);
                responseBodyValues.get(tokenVariableName);
            }
            catch (Exception error) {
                super.logExceptionRecord("getTokenFromResponseBody", YAMLAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(error.getClass().getName(), "getTokenFromResponseBody", error.getMessage()), (Throwable)error);
            }
        }
        return null;
    }

    protected void refreshSecrets() {
        String methodName = "refreshSecrets";
        try {
            this.secretsStore = (SecretsStore)yamlObjectMapper.readValue(this.secretsStoreFile, SecretsStore.class);
        }
        catch (Exception error) {
            super.logRecord("refreshSecrets", YAMLAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(error.getClass().getName(), "refreshSecrets", error.getMessage()));
        }
    }
}

