/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERString;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import edu.illinois.ncsa.bouncycastle.asn1.x500.DirectoryString;
import edu.illinois.ncsa.bouncycastle.asn1.x509.sigi.NameOrPseudonym;
import java.io.IOException;

public class NameOrPseudonymUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "NameOrPseudonym";
    }

    public void performTest() throws Exception {
        String string = "pseudonym";
        DirectoryString directoryString = new DirectoryString("surname");
        DERSequence dERSequence = new DERSequence(new DirectoryString("givenName"));
        NameOrPseudonym nameOrPseudonym = new NameOrPseudonym(string);
        this.checkConstruction(nameOrPseudonym, string, null, null);
        nameOrPseudonym = new NameOrPseudonym(directoryString, dERSequence);
        this.checkConstruction(nameOrPseudonym, null, directoryString, dERSequence);
        nameOrPseudonym = NameOrPseudonym.getInstance(null);
        if (nameOrPseudonym != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            NameOrPseudonym.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(NameOrPseudonym nameOrPseudonym, String string, DirectoryString directoryString, ASN1Sequence aSN1Sequence) throws IOException {
        this.checkValues(nameOrPseudonym, string, directoryString, aSN1Sequence);
        nameOrPseudonym = NameOrPseudonym.getInstance(nameOrPseudonym);
        this.checkValues(nameOrPseudonym, string, directoryString, aSN1Sequence);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(nameOrPseudonym.toASN1Object().getEncoded());
        if (directoryString != null) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1InputStream.readObject();
            nameOrPseudonym = NameOrPseudonym.getInstance(aSN1Sequence2);
        } else {
            DERString dERString = (DERString)((Object)aSN1InputStream.readObject());
            nameOrPseudonym = NameOrPseudonym.getInstance(dERString);
        }
        this.checkValues(nameOrPseudonym, string, directoryString, aSN1Sequence);
    }

    private void checkValues(NameOrPseudonym nameOrPseudonym, String string, DirectoryString directoryString, ASN1Sequence aSN1Sequence) {
        if (directoryString != null) {
            this.checkMandatoryField("surname", directoryString, nameOrPseudonym.getSurname());
            this.checkMandatoryField("givenName", aSN1Sequence, new DERSequence(nameOrPseudonym.getGivenName()[0]));
        } else {
            this.checkOptionalField("pseudonym", new DirectoryString(string), nameOrPseudonym.getPseudonym());
        }
    }

    public static void main(String[] stringArray) {
        NameOrPseudonymUnitTest.runTest(new NameOrPseudonymUnitTest());
    }
}

