/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.isismtt.x509.NamingAuthority;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import edu.illinois.ncsa.bouncycastle.asn1.x500.DirectoryString;
import java.io.IOException;

public class NamingAuthorityUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "NamingAuthority";
    }

    public void performTest() throws Exception {
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier("1.2.3");
        String string = "url";
        DirectoryString directoryString = new DirectoryString("text");
        NamingAuthority namingAuthority = new NamingAuthority(dERObjectIdentifier, string, directoryString);
        this.checkConstruction(namingAuthority, dERObjectIdentifier, string, directoryString);
        namingAuthority = new NamingAuthority(null, string, directoryString);
        this.checkConstruction(namingAuthority, null, string, directoryString);
        namingAuthority = new NamingAuthority(dERObjectIdentifier, null, directoryString);
        this.checkConstruction(namingAuthority, dERObjectIdentifier, null, directoryString);
        namingAuthority = new NamingAuthority(dERObjectIdentifier, string, null);
        this.checkConstruction(namingAuthority, dERObjectIdentifier, string, null);
        namingAuthority = NamingAuthority.getInstance(null);
        if (namingAuthority != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            NamingAuthority.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(NamingAuthority namingAuthority, DERObjectIdentifier dERObjectIdentifier, String string, DirectoryString directoryString) throws IOException {
        this.checkValues(namingAuthority, dERObjectIdentifier, string, directoryString);
        namingAuthority = NamingAuthority.getInstance(namingAuthority);
        this.checkValues(namingAuthority, dERObjectIdentifier, string, directoryString);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(namingAuthority.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        namingAuthority = NamingAuthority.getInstance(aSN1Sequence);
        this.checkValues(namingAuthority, dERObjectIdentifier, string, directoryString);
    }

    private void checkValues(NamingAuthority namingAuthority, DERObjectIdentifier dERObjectIdentifier, String string, DirectoryString directoryString) {
        this.checkOptionalField("namingAuthorityId", dERObjectIdentifier, namingAuthority.getNamingAuthorityId());
        this.checkOptionalField("namingAuthorityURL", string, namingAuthority.getNamingAuthorityUrl());
        this.checkOptionalField("namingAuthorityText", directoryString, namingAuthority.getNamingAuthorityText());
    }

    public static void main(String[] stringArray) {
        NamingAuthorityUnitTest.runTest(new NamingAuthorityUnitTest());
    }
}

