/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.generators;

import edu.illinois.ncsa.bouncycastle.crypto.AsymmetricCipherKeyPair;
import edu.illinois.ncsa.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import edu.illinois.ncsa.bouncycastle.crypto.KeyGenerationParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.DSAParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.params.DSAPublicKeyParameters;
import edu.illinois.ncsa.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DSAKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dSAParameters = this.param.getParameters();
        BigInteger bigInteger = DSAKeyPairGenerator.generatePrivateKey(dSAParameters.getQ(), this.param.getRandom());
        BigInteger bigInteger2 = DSAKeyPairGenerator.calculatePublicKey(dSAParameters.getP(), dSAParameters.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(bigInteger2, dSAParameters), new DSAPrivateKeyParameters(bigInteger, dSAParameters));
    }

    private static BigInteger generatePrivateKey(BigInteger bigInteger, SecureRandom secureRandom) {
        return BigIntegers.createRandomInRange(ONE, bigInteger.subtract(ONE), secureRandom);
    }

    private static BigInteger calculatePublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger2.modPow(bigInteger3, bigInteger);
    }
}

