/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls;

import edu.illinois.ncsa.bouncycastle.crypto.Digest;
import edu.illinois.ncsa.bouncycastle.crypto.digests.MD5Digest;
import edu.illinois.ncsa.bouncycastle.crypto.digests.SHA1Digest;

class CombinedHash
implements Digest {
    private MD5Digest md5;
    private SHA1Digest sha1;

    CombinedHash() {
        this.md5 = new MD5Digest();
        this.sha1 = new SHA1Digest();
    }

    CombinedHash(CombinedHash combinedHash) {
        this.md5 = new MD5Digest(combinedHash.md5);
        this.sha1 = new SHA1Digest(combinedHash.sha1);
    }

    public String getAlgorithmName() {
        return this.md5.getAlgorithmName() + " and " + this.sha1.getAlgorithmName() + " for TLS 1.0";
    }

    public int getDigestSize() {
        return 36;
    }

    public void update(byte by) {
        this.md5.update(by);
        this.sha1.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.md5.update(byArray, n, n2);
        this.sha1.update(byArray, n, n2);
    }

    public int doFinal(byte[] byArray, int n) {
        int n2 = this.md5.doFinal(byArray, n);
        int n3 = this.sha1.doFinal(byArray, n + 16);
        return n2 + n3;
    }

    public void reset() {
        this.md5.reset();
        this.sha1.reset();
    }
}

