/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls;

import edu.illinois.ncsa.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import edu.illinois.ncsa.bouncycastle.asn1.x509.X509CertificateStructure;
import edu.illinois.ncsa.bouncycastle.crypto.InvalidCipherTextException;
import edu.illinois.ncsa.bouncycastle.crypto.encodings.PKCS1Encoding;
import edu.illinois.ncsa.bouncycastle.crypto.engines.RSABlindedEngine;
import edu.illinois.ncsa.bouncycastle.crypto.params.AsymmetricKeyParameter;
import edu.illinois.ncsa.bouncycastle.crypto.params.ParametersWithRandom;
import edu.illinois.ncsa.bouncycastle.crypto.params.RSAKeyParameters;
import edu.illinois.ncsa.bouncycastle.crypto.tls.Certificate;
import edu.illinois.ncsa.bouncycastle.crypto.tls.CertificateRequest;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsClientContext;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsCredentials;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsFatalAlert;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsKeyExchange;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsProtocolVersion;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsSignerCredentials;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsUtils;
import edu.illinois.ncsa.bouncycastle.crypto.util.PublicKeyFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class TlsRSAKeyExchange
implements TlsKeyExchange {
    protected TlsClientContext context;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected RSAKeyParameters rsaServerPublicKey = null;
    protected byte[] premasterSecret;

    TlsRSAKeyExchange(TlsClientContext tlsClientContext) {
        this.context = tlsClientContext;
    }

    public void skipServerCertificate() throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        X509CertificateStructure x509CertificateStructure = certificate.certs[0];
        SubjectPublicKeyInfo subjectPublicKeyInfo = x509CertificateStructure.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(subjectPublicKeyInfo);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(43);
        }
        if (this.serverPublicKey.isPrivate()) {
            throw new TlsFatalAlert(80);
        }
        this.rsaServerPublicKey = this.validateRSAPublicKey((RSAKeyParameters)this.serverPublicKey);
        TlsUtils.validateKeyUsage(x509CertificateStructure, 32);
    }

    public void skipServerKeyExchange() throws IOException {
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        throw new TlsFatalAlert(10);
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] sArray = certificateRequest.getCertificateTypes();
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] <= 255 && sArray[i] >= 0) continue;
            throw new TlsFatalAlert(47);
        }
    }

    public void skipClientCredentials() throws IOException {
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        this.premasterSecret = new byte[48];
        this.context.getSecureRandom().nextBytes(this.premasterSecret);
        this.context.writeClientVersion(this.premasterSecret, 0);
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding(new RSABlindedEngine());
        pKCS1Encoding.init(true, new ParametersWithRandom(this.rsaServerPublicKey, this.context.getSecureRandom()));
        try {
            byte[] byArray = pKCS1Encoding.processBlock(this.premasterSecret, 0, this.premasterSecret.length);
            if (this.context.getNegotiatedVersion() == TlsProtocolVersion.SSLv3) {
                TlsUtils.writeUint24(byArray.length, outputStream);
                outputStream.write(byArray);
            } else {
                TlsUtils.writeUint24(byArray.length + 2, outputStream);
                TlsUtils.writeOpaque16(byArray, outputStream);
            }
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new TlsFatalAlert(80);
        }
    }

    public byte[] generatePremasterSecret() throws IOException {
        byte[] byArray = this.premasterSecret;
        this.premasterSecret = null;
        return byArray;
    }

    protected RSAKeyParameters validateRSAPublicKey(RSAKeyParameters rSAKeyParameters) throws IOException {
        if (!rSAKeyParameters.getExponent().isProbablePrime(2)) {
            throw new TlsFatalAlert(47);
        }
        return rSAKeyParameters;
    }
}

