/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.math.ec.test;

import edu.illinois.ncsa.bouncycastle.asn1.sec.SECNamedCurves;
import edu.illinois.ncsa.bouncycastle.asn1.x9.X9ECParameters;
import edu.illinois.ncsa.bouncycastle.math.ec.ECFieldElement;
import edu.illinois.ncsa.bouncycastle.math.ec.ECPoint;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.Set;

public class F2mProofer {
    private static final int NUM_SAMPLES = 1000;
    private static final String PATH = "crypto/test/src/org/bouncycastle/math/ec/test/samples/";
    private static final String INPUT_FILE_NAME_PREFIX = "Input_";
    private static final String RESULT_FILE_NAME_PREFIX = "Output_";
    public static final String[] CURVES = new String[]{"sect163r2", "sect233r1", "sect283r1", "sect409r1", "sect571r1"};

    private String pointToString(ECPoint.F2m f2m) {
        ECFieldElement.F2m f2m2 = (ECFieldElement.F2m)f2m.getX();
        ECFieldElement.F2m f2m3 = (ECFieldElement.F2m)f2m.getY();
        int n = f2m2.getM();
        int n2 = n / 2 + 5;
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append('(');
        stringBuffer.append(f2m2.toBigInteger().toString(16));
        stringBuffer.append(", ");
        stringBuffer.append(f2m3.toBigInteger().toString(16));
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private void generateRandomInput(X9ECParameters x9ECParameters) throws NoSuchAlgorithmException, IOException {
        Object object;
        ECPoint.F2m f2m = (ECPoint.F2m)x9ECParameters.getG();
        int n = ((ECFieldElement.F2m)f2m.getX()).getM();
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        Properties properties = new Properties();
        for (int i = 0; i < 1000; ++i) {
            object = new BigInteger(n, secureRandom);
            properties.put(Integer.toString(i), ((BigInteger)object).toString(16));
        }
        String string = Integer.toString(n);
        object = new FileOutputStream("crypto/test/src/org/bouncycastle/math/ec/test/samples/Input_" + string + ".properties");
        properties.store((OutputStream)object, "Input Samples of length" + string);
    }

    private void multiplyPoints(X9ECParameters x9ECParameters, String string) throws IOException {
        Object object;
        ECPoint.F2m f2m = (ECPoint.F2m)x9ECParameters.getG();
        int n = ((ECFieldElement.F2m)f2m.getX()).getM();
        String string2 = "crypto/test/src/org/bouncycastle/math/ec/test/samples/Input_" + n + ".properties";
        Properties properties = new Properties();
        properties.load(new FileInputStream(string2));
        Properties properties2 = new Properties();
        for (int i = 0; i < 1000; ++i) {
            object = new BigInteger(properties.getProperty(Integer.toString(i)), 16);
            ECPoint.F2m f2m2 = (ECPoint.F2m)f2m.multiply((BigInteger)object);
            String string3 = this.pointToString(f2m2);
            properties2.setProperty(Integer.toString(i), string3);
        }
        String string4 = "crypto/test/src/org/bouncycastle/math/ec/test/samples/Output_" + string + "_" + n + ".properties";
        object = new FileOutputStream(string4);
        properties2.store((OutputStream)object, "Output Samples of length" + n);
    }

    private Properties loadResults(String string, int n) throws IOException {
        FileInputStream fileInputStream = new FileInputStream("crypto/test/src/org/bouncycastle/math/ec/test/samples/Output_" + string + "_" + n + ".properties");
        Properties properties = new Properties();
        properties.load(fileInputStream);
        return properties;
    }

    private void compareResult(X9ECParameters x9ECParameters, String string, String string2) throws IOException {
        ECPoint.F2m f2m = (ECPoint.F2m)x9ECParameters.getG();
        int n = ((ECFieldElement.F2m)f2m.getX()).getM();
        Properties properties = this.loadResults(string, n);
        Properties properties2 = this.loadResults(string2, n);
        Set<Object> set = properties.keySet();
        for (String string3 : set) {
            String string4;
            String string5 = properties.getProperty(string3);
            if (string5.equals(string4 = properties2.getProperty(string3))) continue;
            System.err.println("Difference found: m = " + n + ", " + string5 + " does not equal " + string4);
        }
    }

    private static void usage() {
        System.err.println("Usage: F2mProofer [-init | -multiply <className> | -compare <className1> <className2>]");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            F2mProofer.usage();
            return;
        }
        F2mProofer f2mProofer = new F2mProofer();
        if (stringArray[0].equals("-init")) {
            System.out.println("Generating random input...");
            for (int i = 0; i < CURVES.length; ++i) {
                X9ECParameters x9ECParameters = SECNamedCurves.getByName(CURVES[i]);
                f2mProofer.generateRandomInput(x9ECParameters);
            }
            System.out.println("Successfully generated random input in crypto/test/src/org/bouncycastle/math/ec/test/samples/");
        } else if (stringArray[0].equals("-compare")) {
            if (stringArray.length < 3) {
                F2mProofer.usage();
                return;
            }
            String string = stringArray[1];
            String string2 = stringArray[2];
            System.out.println("Comparing results...");
            for (int i = 0; i < CURVES.length; ++i) {
                X9ECParameters x9ECParameters = SECNamedCurves.getByName(CURVES[i]);
                f2mProofer.compareResult(x9ECParameters, string, string2);
            }
            System.out.println("Successfully compared results in crypto/test/src/org/bouncycastle/math/ec/test/samples/");
        } else if (stringArray[0].equals("-multiply")) {
            if (stringArray.length < 2) {
                F2mProofer.usage();
                return;
            }
            String string = stringArray[1];
            System.out.println("Multiplying points...");
            for (int i = 0; i < CURVES.length; ++i) {
                X9ECParameters x9ECParameters = SECNamedCurves.getByName(CURVES[i]);
                f2mProofer.multiplyPoints(x9ECParameters, string);
            }
            System.out.println("Successfully generated multiplied points in crypto/test/src/org/bouncycastle/math/ec/test/samples/");
        } else {
            F2mProofer.usage();
        }
    }
}

