/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/*
 * Copyright (c) 2004-2005 Extreme! Lab, Indiana University. All rights reserved.
 *
 * This software is open source. See the bottom of this file for the licence.
 *
 * $Id: GpelConstants.java,v 1.15 2008/05/16 22:31:56 cherath Exp $
 */
package org.gpel;

import org.gpel.GpelConstants;
import org.gpel.logger.GLogger;
import org.xmlpull.infoset.XmlInfosetBuilder;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.v1.XmlPullParserFactory;

public class GpelConstants {
    private final static GLogger logger = GLogger.getLogger();
    public static XmlInfosetBuilder BUILDER;

    public final static String NS_URI_XSD = "http://www.w3.org/2001/XMLSchema";
    public final static String NS_URI_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public final static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    public final static String NS_URI_XML = "http://www.w3.org/XML/1998/namespace";
        
    public final static String NS_URI_BPEL = "http://docs.oasis-open.org/wsbpel/2.0/process/executable";
    public final static String NS_URI_GPEL = "http://schemas.gpel.org/2005/grid-process/";
    public final static String NS_URI_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    public final static String NS_URI_ATOM = "http://www.w3.org/2005/Atom";

    public final static String REL_WSDL = NS_URI_GPEL+"wsdl";
    public final static String REL_PROCESS = NS_URI_GPEL+"process";
    public final static String REL_TEMPLATE = NS_URI_GPEL+"template";
    public final static String REL_INSTANCE = NS_URI_GPEL+"instance";
    public final static String REL_STATE = NS_URI_GPEL+"state";
    public final static String REL_USES_WSDL = NS_URI_GPEL+"uses-wsdl";
    public final static String REL_PROVIDES_WSDL = NS_URI_GPEL+"provides-wsdl";
    public final static String REL_OUTGOING_QUEUE = NS_URI_GPEL+"outgoing-queue";
    public final static String REL_INCOMING_QUEUE = NS_URI_GPEL+"incoming-queue";
    //public final static String REL_OUTGOING_QUEUE = NS_URI_GPEL+"event-sink";

    // WS-Addressing related constants to access messages directly
    public final static String WSA_ACTION_EL = "Action";
    public final static String WSA_ADDRESS_EL = "Address";
    public final static String WSA_REPLY_TO_EL = "ReplyTo";
    public final static String WSA_MESSAGE_ID_EL = "MessageID";
    public final static String WSA_TO_EL = "To";
    public final static String WSA_REFERENCE_PROPERTIES_EL = "ReferenceProperties";


    public final static String XSD_PREFIX = "xsd";
    public final static String XSI_PREFIX = "xsi";
    public final static String XML_PREFIX = "xml";
    public final static String BPEL_PREFIX = "bpel";
    public final static String GPEL_PREFIX = "gpel";
    public final static String WSDL_PREFIX = "wsdl";

    public final static XmlNamespace XS_NS;
    public final static XmlNamespace XSI_NS;
    public final static XmlNamespace XML_NS;
    public final static XmlNamespace BPEL_NS;
    public static XmlNamespace GPEL_NS;
    public final static XmlNamespace WSDL_NS;
    public final static XmlNamespace ATOM_NS;
    public final static XmlNamespace WSA_NS;

    static {
        try {
            BUILDER = XmlInfosetBuilder.newInstance();
        } catch (java.security.AccessControlException aex) {
            logger.config("cant load default XmlPull parser factory (running in applet?)", aex);
            try {
                //XmlPullParserFactory factory = new MXParserFactory();
                String classNames = "org.xmlpull.mxp5.MXParser,org.xmlpull.mxp5_serializer.MXSerializer";
                XmlPullParserFactory factory = XmlPullParserFactory.newInstance(classNames,
                                                 GpelConstants.class);
                BUILDER = new org.xmlpull.b5.XmlPullInfosetBuilder(factory);

            } catch (Exception e) {
                //this is fatal error! this SHOULD NEVER happen but ...
                String msg = "could not fallback to XPP5/MXP5 parser factory";
                logger.severe(msg, e);
                System.err.println(msg);
                e.printStackTrace();
                throw new GpelException(msg, e);
            }
        }
        XS_NS = BUILDER.newNamespace(XSD_PREFIX, NS_URI_XSD);
        XSI_NS = BUILDER.newNamespace(XSI_PREFIX, NS_URI_XSI);
        XML_NS  = BUILDER.newNamespace(XML_PREFIX, NS_URI_XML);
        BPEL_NS  = BUILDER.newNamespace(BPEL_PREFIX, NS_URI_BPEL);
        GPEL_NS  = BUILDER.newNamespace(GPEL_PREFIX, NS_URI_GPEL);
        WSDL_NS  = BUILDER.newNamespace(WSDL_PREFIX, NS_URI_WSDL);
        ATOM_NS  = BUILDER.newNamespace("atom", NS_URI_ATOM);
        WSA_NS = BUILDER.newNamespace("wsa", "http://www.w3.org/2005/08/addressing");
    }

}
/*
 * 
* Indiana University Extreme! Lab Software License, Version 1.2
*
* Copyright (c) 2004-2005 The Trustees of Indiana University.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are
* met:
*
* 1) All redistributions of source code must retain the above
*    copyright notice, the list of authors in the original source
*    code, this list of conditions and the disclaimer listed in this
*    license;
*
* 2) All redistributions in binary form must reproduce the above
*    copyright notice, this list of conditions and the disclaimer
*    listed in this license in the documentation and/or other
*    materials provided with the distribution;
*
* 3) Any documentation included with all redistributions must include
*    the following acknowledgement:
*
*      "This product includes software developed by the Indiana
*      University Extreme! Lab.  For further information please visit
*      http://www.extreme.indiana.edu/"
*
*    Alternatively, this acknowledgment may appear in the software
*    itself, and wherever such third-party acknowledgments normally
*    appear.
*
* 4) The name "Indiana University" or "Indiana University
*    Extreme! Lab" shall not be used to endorse or promote
*    products derived from this software without prior written
*    permission from Indiana University.  For written permission,
*    please contact http://www.extreme.indiana.edu/.
*
* 5) Products derived from this software may not use "Indiana
*    University" name nor may "Indiana University" appear in their name,
*    without prior written permission of the Indiana University.
*
* Indiana University provides no reassurances that the source code
* provided does not infringe the patent or any other intellectual
* property rights of any other entity.  Indiana University disclaims any
* liability to any recipient for claims brought by any other entity
* based on infringement of intellectual property rights or otherwise.
*
* LICENSEE UNDERSTANDS THAT SOFTWARE IS PROVIDED "AS IS" FOR WHICH
* NO WARRANTIES AS TO CAPABILITIES OR ACCURACY ARE MADE. INDIANA
* UNIVERSITY GIVES NO WARRANTIES AND MAKES NO REPRESENTATION THAT
* SOFTWARE IS FREE OF INFRINGEMENT OF THIRD PARTY PATENT, COPYRIGHT, OR
* OTHER PROPRIETARY RIGHTS.  INDIANA UNIVERSITY MAKES NO WARRANTIES THAT
* SOFTWARE IS FREE FROM "BUGS", "VIRUSES", "TROJAN HORSES", "TRAP
* DOORS", "WORMS", OR OTHER HARMFUL CODE.  LICENSEE ASSUMES THE ENTIRE
* RISK AS TO THE PERFORMANCE OF SOFTWARE AND/OR ASSOCIATED MATERIALS,
* AND TO THE PERFORMANCE AND VALIDITY OF INFORMATION GENERATED USING
* SOFTWARE.
*/


