/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/* Copyright (c) 2005 Extreme! Lab, Indiana University. All rights reserved.
 * This software is open source. See the bottom of this file for the license.
 * $Id: GcBinaryWebResource.java,v 1.8 2006/12/07 04:55:28 aslom Exp $ */
package org.gpel.client;

import org.gpel.client.util.base64.Base64;
import org.xmlpull.infoset.XmlElement;

public class GcBinaryWebResource extends GcAtomResource implements GcWebResource {
    public final static String DEFAULT_MIME_TYPE = "application/octet-stream";
    
    public GcBinaryWebResource(String resourceName, byte[] binaryContent) {
        this(resourceName, binaryContent, DEFAULT_MIME_TYPE);
    }
    
    public GcBinaryWebResource(String resourceName, byte[] binaryContent, String mimeType) {
        super(resourceName, mimeType);
        setBinaryContent(binaryContent);
        setMimeType(mimeType);
    }

    public GcBinaryWebResource(XmlElement atomRes) {
        super(atomRes);
    }
        
    public void setBinaryContent(byte[] binaryContent) {
        String s = new String(Base64.encode(binaryContent));
        XmlElement contentEl = getContentEl(true);
        contentEl.removeAllChildren();
        contentEl.addChild(s);
    }
    
    public byte[] getBinaryContent() {
        XmlElement contentEl = getContentEl(true);
        String s = contentEl.requiredText();
        byte[] binaryContent = Base64.decode(s.toCharArray());
        return binaryContent;
    }

    public void setMimeType(String mimeType) {
        if(mimeType == null) throw new IllegalArgumentException();
        if(!GcWebResourceType.BINARY.equals( GcUtil.categorizeContentType(mimeType)) ) {
            throw new IllegalArgumentException("MIME type must be binary not "+mimeType);
        }
        super.setMimeType(mimeType);
    }
    
}

