/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/* Copyright (c) 2005 Extreme! Lab, Indiana University. All rights reserved.
 * This software is open source. See the bottom of this file for the license.
 * $Id: GcDefaultSupportedLinksFilter.java,v 1.5 2006/12/07 04:55:28 aslom Exp $
 */
package org.gpel.client;

import org.gpel.GpelConstants;

public class GcDefaultSupportedLinksFilter implements GcLinkFilter {
    
    public boolean accept(GcLink link) {
        String rel = link.getRel();
        //String href = link.getHref();
        if (rel.equals(GpelConstants.REL_WSDL)) {
            return true;
        } else if (rel.equals(GpelConstants.REL_PROCESS)) {
            return true;
        } else if (rel.equals(GpelConstants.REL_TEMPLATE)) {
            return true;
        } else if (rel.equals(GpelConstants.REL_INSTANCE)) {
            return true;
        } else if (rel.equals(GpelConstants.REL_USES_WSDL)) {
            return true;
        } else if (rel.equals(GpelConstants.REL_PROVIDES_WSDL)) {
            return true;
        } else if (rel.equals(GpelConstants.REL_INCOMING_QUEUE)) {
            return true;
        } else if (rel.equals(GpelConstants.REL_OUTGOING_QUEUE)) {
            return true;
        } else if (rel.equals(GpelConstants.REL_STATE)) {
            return true;
        }
        return false;
    }
}

