/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/* Copyright (c) 2005 Extreme! Lab, Indiana University. All rights reserved.
 * This software is open source. See the bottom of this file for the license.
 * $Id: GcResourceNotFoundException.java,v 1.2 2006/12/07 04:55:28 aslom Exp $ */
package org.gpel.client;

import java.net.URI;
import org.gpel.client.GcException;

/**
 * Resource could not be found at given location.
 */
public class GcResourceNotFoundException extends GcException {
    private URI location;
    
    public GcResourceNotFoundException(String reason, URI location) {
        super(reason);
        this.location = location;
    }
    
    
    public GcResourceNotFoundException(String reason, URI location, Throwable thrwble) {
        super(reason, thrwble);
        this.location = location;
    }
    
//  public void setLocation(URI location) {
//      this.location = location;
//  }
    
    public URI getLocation() {
        return location;
    }
    
}

