/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/* Copyright (c) 2005 Extreme! Lab, Indiana University. All rights reserved.
 * This software is open source. See the bottom of this file for the license.
 * $Id: GcTextWebResource.java,v 1.7 2006/12/07 04:55:28 aslom Exp $ */
package org.gpel.client;

import java.net.URI;
import org.gpel.GpelConstants;
import org.xmlpull.infoset.XmlElement;

public class GcTextWebResource extends GcAtomResource implements GcWebResource {
    public final static String DEFAULT_MIME_TYPE = "text/plain";

    public GcTextWebResource(String title, String textContent) {
        this(title, textContent, DEFAULT_MIME_TYPE);
    }
    
    public GcTextWebResource(String title, String textContent, String mimeType) {
        super(title, mimeType);
        setMimeType(mimeType);
        setTextContent(textContent);
        //this.textContent = textContent;
    }

    public GcTextWebResource(XmlElement atomRes) {
        super(atomRes);
    }
        
    private void setTextContent(String textContent) {
        XmlElement contentEl = getContentEl(true);
        contentEl.setText(textContent);
    }
    
    public String getTextContent() {
        XmlElement contentEl = getContentEl(true);
        String textContent = contentEl.requiredText();
        return textContent;
    }
    
    public void setMimeType(String mimeType) {
        if(mimeType == null) throw new IllegalArgumentException();
        if(!GcWebResourceType.TEXT.equals( GcUtil.categorizeContentType(mimeType)) ) {
            throw new IllegalArgumentException("content type must be text and not "+mimeType);
        }
        super.setMimeType(mimeType);
    }
        
}

