/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/* Copyright (c) 2005 Extreme! Lab, Indiana University. All rights reserved.
 * This software is open source. See the bottom of this file for the license.
 * $Id: GcWsdlResource.java,v 1.8 2006/12/07 04:55:28 aslom Exp $ */
package org.gpel.client;

import org.gpel.GpelConstants;
import org.xmlpull.infoset.XmlElement;

import xsul.wsdl.WsdlDefinitions;

public class GcWsdlResource extends GcXmlWebResource {
    public final static String REL = GpelConstants.REL_WSDL;
    public final static String MIME_TYPE = "application/wsdl+xml";
    

    public GcWsdlResource(XmlElement atomRes) {
        super(atomRes);
    }

    
    public String getRel() {
        return REL;
    }
    public void setRel(String rel) {
        if(rel == null) throw new IllegalArgumentException();
        if(! getRel().equals(rel)) {
            throw new GcException("only rel "+getRel()+" is suported for WSDL resource not "+rel);
        }
    }
}


