/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/* Copyright (c) 2005 Extreme! Lab, Indiana University. All rights reserved.
 * This software is open source. See the bottom of this file for the license.
 * $Id: GpelUserCredentials.java,v 1.4 2006/12/21 20:19:34 aslom Exp $ */
package org.gpel.client;

/**
 * Represent user credentials (user name, password, etc) used to authenticate
 * and authorize user to GPEL engine.
 */
public class GpelUserCredentials {
    private String userName; //ex.: LEAD userId cn=GpelTest,...
    private String userPassword;

    public GpelUserCredentials(String userName, String userPassword) {
        if(userName == null || userName.length() == 0) throw new IllegalArgumentException();
        if(userPassword == null || userPassword.length() == 0) throw new IllegalArgumentException();
        this.userName = userName;
        this.userPassword = userPassword;
    }


//    public void setUserName(String userId) {
//        this.userName = userId;
//    }

    public String getUserName() {
        return userName;
    }

//    public void setUserPassword(String userPassword) {
//        this.userPassword = userPassword;
//    }

    public String getUserPassword() {
        return userPassword;
    }


}

