/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/*
 * Copyright (c) 2004-2005 Extreme! Lab, Indiana University. All rights reserved.
 *
 * This software is open source. See the bottom of this file for the license.
 *
 * $Id: GpelActivity.java,v 1.4 2006/12/07 04:55:31 aslom Exp $
 */
package org.gpel.model;

import org.gpel.GpelConstants;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;

public abstract class GpelActivity extends GpelModelBase {
    private static final String INTERNAL_STMT_ID_ATTR = "statementId";
    private static final String NAME_ATTR = "name";

    public GpelActivity(String typeName, XmlElement target) {
        super(typeName, target);
    }

    public GpelActivity(XmlNamespace ns, String typeName) {
        super(ns, typeName);
    }

    /**
     * Set partnerLink.
     */
    public void setInternalStatementId(String stmtId) {
        xml.setAttributeValue(GpelConstants.GPEL_NS, INTERNAL_STMT_ID_ATTR, stmtId);
    }

    /**
     * Returns partnerLink;
     */
    public String getInternalStatementId() {
        return xml.attributeValue(GpelConstants.GPEL_NS, INTERNAL_STMT_ID_ATTR);
    }

    public static GpelActivity convertElementToActivity(XmlElement el) throws GpelModelValidationException {
        GpelActivity activity = convertElementToActivityIfPossible(el);
        if(activity == null) {
            throw new GpelModelValidationException(
            "could not make into activity this element "+builder.serializeToString(el));
        }
        return activity;
    }

    public static GpelActivity convertElementToActivityIfPossible(XmlElement el) throws GpelModelValidationException {
        XmlNamespace ns = el.getNamespace();
        String name = el.getName();
        if(GpelInvoke.TYPE_NAME.equals(name)) {
            return el.viewAs(GpelInvoke.class);
        } else if(GpelReceive.TYPE_NAME.equals(name)) {
            return el.viewAs(GpelReceive.class);
        } else if(GpelReply.TYPE_NAME.equals(name)) {
            return el.viewAs(GpelReply.class);
        } else if(GpelAssign.TYPE_NAME.equals(name)) {
            return el.viewAs(GpelAssign.class);
        } else if(GpelFlow.TYPE_NAME.equals(name)) {
            return el.viewAs(GpelFlow.class);
        } else if(GpelSequence.TYPE_NAME.equals(name)) {
            return el.viewAs(GpelSequence.class);
        } else if(GpelIf.TYPE_NAME.equals(name)) {
            return el.viewAs(GpelIf.class);
        } else if(GpelElse.TYPE_NAME.equals(name)) {
            return el.viewAs(GpelElse.class);
        } else if(GpelElseIf.TYPE_NAME.equals(name)) {
            return el.viewAs(GpelElseIf.class);
        } else if(GpelForEach.TYPE_NAME.equals(name)) {
            return el.viewAs(GpelForEach.class);
        } else if(GpelScope.TYPE_NAME.equals(name)) {
            return el.viewAs(GpelScope.class);
        }
        return null;
    }

    public void setName(String name) {
        xml().setAttributeValue(NAME_ATTR, name);
    }

    public String getName() {
        return xml().attributeValue(NAME_ATTR);
    }

}

/*
 * Indiana University Extreme! Lab Software License, Version 1.2
 *
 * Copyright (c) 2004-2005 The Trustees of Indiana University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * 1) All redistributions of source code must retain the above
 *    copyright notice, the list of authors in the original source
 *    code, this list of conditions and the disclaimer listed in this
 *    license;
 *
 * 2) All redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the disclaimer
 *    listed in this license in the documentation and/or other
 *    materials provided with the distribution;
 *
 * 3) Any documentation included with all redistributions must include
 *    the following acknowledgement:
 *
 *      "This product includes software developed by the Indiana
 *      University Extreme! Lab.  For further information please visit
 *      http://www.extreme.indiana.edu/"
 *
 *    Alternatively, this acknowledgment may appear in the software
 *    itself, and wherever such third-party acknowledgments normally
 *    appear.
 *
 * 4) The name "Indiana University" or "Indiana University
 *    Extreme! Lab" shall not be used to endorse or promote
 *    products derived from this software without prior written
 *    permission from Indiana University.  For written permission,
 *    please contact http://www.extreme.indiana.edu/.
 *
 * 5) Products derived from this software may not use "Indiana
 *    University" name nor may "Indiana University" appear in their name,
 *    without prior written permission of the Indiana University.
 *
 * Indiana University provides no reassurances that the source code
 * provided does not infringe the patent or any other intellectual
 * property rights of any other entity.  Indiana University disclaims any
 * liability to any recipient for claims brought by any other entity
 * based on infringement of intellectual property rights or otherwise.
 *
 * LICENSEE UNDERSTANDS THAT SOFTWARE IS PROVIDED "AS IS" FOR WHICH
 * NO WARRANTIES AS TO CAPABILITIES OR ACCURACY ARE MADE. INDIANA
 * UNIVERSITY GIVES NO WARRANTIES AND MAKES NO REPRESENTATION THAT
 * SOFTWARE IS FREE OF INFRINGEMENT OF THIRD PARTY PATENT, COPYRIGHT, OR
 * OTHER PROPRIETARY RIGHTS.  INDIANA UNIVERSITY MAKES NO WARRANTIES THAT
 * SOFTWARE IS FREE FROM "BUGS", "VIRUSES", "TROJAN HORSES", "TRAP
 * DOORS", "WORMS", OR OTHER HARMFUL CODE.  LICENSEE ASSUMES THE ENTIRE
 * RISK AS TO THE PERFORMANCE OF SOFTWARE AND/OR ASSOCIATED MATERIALS,
 * AND TO THE PERFORMANCE AND VALIDITY OF INFORMATION GENERATED USING
 * SOFTWARE.
 */


