/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/*
 * Copyright (c) 2004-2005 Extreme! Lab, Indiana University. All rights reserved.
 *
 * This software is open source. See the bottom of this file for the license.
 *
 * $Id: GpelContainerActivity.java,v 1.4 2006/12/07 05:13:17 aslom Exp $
 */
package org.gpel.model;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.view.XmlValidationException;

public abstract class GpelContainerActivity extends GpelActivity {

    public GpelContainerActivity(String typeName, XmlElement target) {
        super(typeName, target);
    }

    public GpelContainerActivity(XmlNamespace ns, String typeName) {
        super(ns, typeName);
    }

    public void addActivity(GpelActivity act) {
        xml().addElement(act.xml());
    }

    public Iterable<GpelActivity> activities() {
        final Iterator<XmlElement> elContent = xml().requiredElementContent().iterator();
        Iterable<GpelActivity> giterable = new Iterable<GpelActivity>() {
            public Iterator<GpelActivity> iterator() {
                return new Iterator<GpelActivity>() {
                    GpelActivity nextActivityIfAny = findNext();;

                    private GpelActivity findNext() {
                        while(elContent.hasNext()) {
                            XmlElement el = elContent.next();
                            GpelActivity nextActivity = convertElementToActivityIfPossible(el);
                            if(nextActivity != null) {
                                return nextActivity;
                            }
                        }
                        return null;
                    }

                    public boolean hasNext() {
                        boolean exists = nextActivityIfAny != null;
                        //return elContent.hasNext();
                        return exists;
                    }

                    public GpelActivity next() {
                        if(nextActivityIfAny == null) {
                            throw new IllegalStateException();
                        }
                        GpelActivity a = nextActivityIfAny;
                        nextActivityIfAny = findNext();
                        return a;
                    }


                    public void remove() {
                        elContent.remove();
                    }

                };
            }
        };
        return giterable;
    }

    public void xmlValidate() {
        for(GpelActivity activity : activities()) {
            activity.xmlValidate();
        }
    }

}

/*
* Indiana University Extreme! Lab Software License, Version 1.2
*
* Copyright (c) 2004-2005 The Trustees of Indiana University.
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are
* met:
*
* 1) All redistributions of source code must retain the above
*    copyright notice, the list of authors in the original source
*    code, this list of conditions and the disclaimer listed in this
*    license;
*
* 2) All redistributions in binary form must reproduce the above
*    copyright notice, this list of conditions and the disclaimer
*    listed in this license in the documentation and/or other
*    materials provided with the distribution;
*
* 3) Any documentation included with all redistributions must include
*    the following acknowledgement:
*
*      "This product includes software developed by the Indiana
*      University Extreme! Lab.  For further information please visit
*      http://www.extreme.indiana.edu/"
*
*    Alternatively, this acknowledgment may appear in the software
*    itself, and wherever such third-party acknowledgments normally
*    appear.
*
* 4) The name "Indiana University" or "Indiana University
*    Extreme! Lab" shall not be used to endorse or promote
*    products derived from this software without prior written
*    permission from Indiana University.  For written permission,
*    please contact http://www.extreme.indiana.edu/.
*
* 5) Products derived from this software may not use "Indiana
*    University" name nor may "Indiana University" appear in their name,
*    without prior written permission of the Indiana University.
*
* Indiana University provides no reassurances that the source code
* provided does not infringe the patent or any other intellectual
* property rights of any other entity.  Indiana University disclaims any
* liability to any recipient for claims brought by any other entity
* based on infringement of intellectual property rights or otherwise.
*
* LICENSEE UNDERSTANDS THAT SOFTWARE IS PROVIDED "AS IS" FOR WHICH
* NO WARRANTIES AS TO CAPABILITIES OR ACCURACY ARE MADE. INDIANA
* UNIVERSITY GIVES NO WARRANTIES AND MAKES NO REPRESENTATION THAT
* SOFTWARE IS FREE OF INFRINGEMENT OF THIRD PARTY PATENT, COPYRIGHT, OR
* OTHER PROPRIETARY RIGHTS.  INDIANA UNIVERSITY MAKES NO WARRANTIES THAT
* SOFTWARE IS FREE FROM "BUGS", "VIRUSES", "TROJAN HORSES", "TRAP
* DOORS", "WORMS", OR OTHER HARMFUL CODE.  LICENSEE ASSUMES THE ENTIRE
* RISK AS TO THE PERFORMANCE OF SOFTWARE AND/OR ASSOCIATED MATERIALS,
* AND TO THE PERFORMANCE AND VALIDITY OF INFORMATION GENERATED USING
* SOFTWARE.
*/


