/*
 * Decompiled with CFR 0.152.
 */
package org.gpel;

import java.security.AccessControlException;
import org.gpel.GpelException;
import org.gpel.logger.GLogger;
import org.xmlpull.b5.XmlPullInfosetBuilder;
import org.xmlpull.infoset.XmlInfosetBuilder;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.v1.XmlPullParserFactory;

public class GpelConstants {
    private static final GLogger logger = GLogger.getLogger();
    public static XmlInfosetBuilder BUILDER;
    public static final String NS_URI_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String NS_URI_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    public static final String NS_URI_XML = "http://www.w3.org/XML/1998/namespace";
    public static final String NS_URI_BPEL = "http://docs.oasis-open.org/wsbpel/2.0/process/executable";
    public static final String NS_URI_GPEL = "http://schemas.gpel.org/2005/grid-process/";
    public static final String NS_URI_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    public static final String NS_URI_ATOM = "http://www.w3.org/2005/Atom";
    public static final String REL_WSDL = "http://schemas.gpel.org/2005/grid-process/wsdl";
    public static final String REL_PROCESS = "http://schemas.gpel.org/2005/grid-process/process";
    public static final String REL_TEMPLATE = "http://schemas.gpel.org/2005/grid-process/template";
    public static final String REL_INSTANCE = "http://schemas.gpel.org/2005/grid-process/instance";
    public static final String REL_STATE = "http://schemas.gpel.org/2005/grid-process/state";
    public static final String REL_USES_WSDL = "http://schemas.gpel.org/2005/grid-process/uses-wsdl";
    public static final String REL_PROVIDES_WSDL = "http://schemas.gpel.org/2005/grid-process/provides-wsdl";
    public static final String REL_OUTGOING_QUEUE = "http://schemas.gpel.org/2005/grid-process/outgoing-queue";
    public static final String REL_INCOMING_QUEUE = "http://schemas.gpel.org/2005/grid-process/incoming-queue";
    public static final String WSA_ACTION_EL = "Action";
    public static final String WSA_ADDRESS_EL = "Address";
    public static final String WSA_REPLY_TO_EL = "ReplyTo";
    public static final String WSA_MESSAGE_ID_EL = "MessageID";
    public static final String WSA_TO_EL = "To";
    public static final String WSA_REFERENCE_PROPERTIES_EL = "ReferenceProperties";
    public static final String XSD_PREFIX = "xsd";
    public static final String XSI_PREFIX = "xsi";
    public static final String XML_PREFIX = "xml";
    public static final String BPEL_PREFIX = "bpel";
    public static final String GPEL_PREFIX = "gpel";
    public static final String WSDL_PREFIX = "wsdl";
    public static final XmlNamespace XS_NS;
    public static final XmlNamespace XSI_NS;
    public static final XmlNamespace XML_NS;
    public static final XmlNamespace BPEL_NS;
    public static XmlNamespace GPEL_NS;
    public static final XmlNamespace WSDL_NS;
    public static final XmlNamespace ATOM_NS;
    public static final XmlNamespace WSA_NS;

    static {
        try {
            BUILDER = XmlInfosetBuilder.newInstance();
        }
        catch (AccessControlException aex) {
            logger.config("cant load default XmlPull parser factory (running in applet?)", aex);
            try {
                String classNames = "org.xmlpull.mxp5.MXParser,org.xmlpull.mxp5_serializer.MXSerializer";
                XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)classNames, GpelConstants.class);
                BUILDER = new XmlPullInfosetBuilder(factory);
            }
            catch (Exception e) {
                String msg = "could not fallback to XPP5/MXP5 parser factory";
                logger.severe(msg, e);
                System.err.println(msg);
                e.printStackTrace();
                throw new GpelException(msg, e);
            }
        }
        XS_NS = BUILDER.newNamespace(XSD_PREFIX, NS_URI_XSD);
        XSI_NS = BUILDER.newNamespace(XSI_PREFIX, NS_URI_XSI);
        XML_NS = BUILDER.newNamespace(XML_PREFIX, NS_URI_XML);
        BPEL_NS = BUILDER.newNamespace(BPEL_PREFIX, NS_URI_BPEL);
        GPEL_NS = BUILDER.newNamespace(GPEL_PREFIX, NS_URI_GPEL);
        WSDL_NS = BUILDER.newNamespace(WSDL_PREFIX, NS_URI_WSDL);
        ATOM_NS = BUILDER.newNamespace("atom", NS_URI_ATOM);
        WSA_NS = BUILDER.newNamespace("wsa", "http://www.w3.org/2005/08/addressing");
    }
}

