/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.client;

import java.net.URI;
import org.gpel.GpelConstants;
import org.gpel.client.GcException;
import org.gpel.client.GcUtil;
import org.gpel.client.GcWebResource;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlInfosetBuilder;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.view.TypedXmlElementView;
import org.xmlpull.infoset.view.XmlValidationException;

public abstract class GcAtomResource
extends TypedXmlElementView
implements GcWebResource {
    private static final XmlInfosetBuilder builder = GpelConstants.BUILDER;
    private URI location;
    private String rel;

    public GcAtomResource(String title, String mimeType) {
        super(builder.newFragment(GcUtil.ATOM_NS, "entry"));
        if (title == null) {
            throw new IllegalArgumentException();
        }
        this.setTitle(title);
        this.setMimeType(mimeType);
    }

    public GcAtomResource(XmlElement atomRes) {
        super(atomRes);
        if (!atomRes.getNamespace().equals(GcUtil.ATOM_NS)) {
            throw new XmlValidationException("must be in ATOM namespace");
        }
        if (!atomRes.getName().equals("entry")) {
            throw new XmlValidationException("must be atom:entry");
        }
        if (this.getTitle(false) == null) {
            throw new XmlValidationException("required atom:title");
        }
        if (this.getContentEl(false) == null) {
            throw new XmlValidationException("required atom:content");
        }
    }

    public XmlNamespace xmlTypeNs() {
        return this.xml().getNamespace();
    }

    public String xmlTypeName() {
        return this.xml().getName();
    }

    public void xmlSet(XmlElement xmlEl) {
        this.xml = xmlEl;
    }

    protected XmlElement getContentEl(boolean create) {
        return this.xml().element(GcUtil.ATOM_NS, "content", create);
    }

    @Override
    public URI getId() throws GcException {
        XmlElement idEl = this.xml().element(GpelConstants.ATOM_NS, "id");
        if (idEl == null) {
            throw new GcException("resource must be first deployed to server have id");
        }
        String id = idEl.requiredText();
        return URI.create(id);
    }

    @Override
    public String getMimeType() {
        XmlElement contentEl = this.getContentEl(true);
        String mimeType = contentEl.attributeValue("type");
        return mimeType;
    }

    @Override
    public void setMimeType(String mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException();
        }
        XmlElement contentEl = this.getContentEl(true);
        contentEl.setAttributeValue("type", mimeType);
    }

    public String getTitle(boolean require) throws GcException {
        XmlElement titleEl;
        if (require) {
            titleEl = this.xml().requiredElement(GcUtil.ATOM_NS, "title");
        } else {
            titleEl = this.xml().element(GcUtil.ATOM_NS, "title");
            if (titleEl == null) {
                return null;
            }
        }
        String title = titleEl.requiredText();
        return title;
    }

    @Override
    public String getTitle() throws GcException {
        return this.getTitle(true);
    }

    @Override
    public void setTitle(String title) throws GcException {
        XmlElement titleEl = this.xml().element(GpelConstants.ATOM_NS, "title", true);
        titleEl.setText(title);
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(URI location) {
        this.location = location;
    }

    @Override
    public String getRel() {
        return this.rel;
    }

    @Override
    public void setRel(String rel) {
        this.rel = rel;
    }
}

