/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.gpel.GpelConstants;
import org.gpel.client.GcAtomResource;
import org.gpel.client.GcDefaultSupportedLinksFilter;
import org.gpel.client.GcException;
import org.gpel.client.GcInstance;
import org.gpel.client.GcLinkFilter;
import org.gpel.client.GcSearchList;
import org.gpel.client.GcSearchRequest;
import org.gpel.client.GcSearchResult;
import org.gpel.client.GcTemplate;
import org.gpel.client.GcUtil;
import org.gpel.client.GcWebResource;
import org.gpel.client.http.GcDefaultWebResourceFromHttp;
import org.gpel.client.http.GcDefaultWebResourceToHttp;
import org.gpel.client.http.GcHttpRequest;
import org.gpel.client.http.GcHttpResponse;
import org.gpel.client.http.GcHttpTransport;
import org.gpel.client.http.GcWebResourceFromHttp;
import org.gpel.client.http.GcWebResourceToHttp;
import org.gpel.logger.GLogger;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlInfosetBuilder;

public class GpelClient {
    private static final XmlInfosetBuilder builder = GpelConstants.BUILDER;
    private static final GLogger logger = GLogger.getLogger();
    private GcHttpTransport transport;
    private GcWebResourceFromHttp resFromHttp = GcDefaultWebResourceFromHttp.getInstance();
    private GcWebResourceToHttp resToHttp = GcDefaultWebResourceToHttp.getInstance();
    private GcLinkFilter filter = new GcDefaultSupportedLinksFilter();
    private URI gpelNewPostLocation;
    private String gpelSpaceGuid;
    private URI gpelSpaceLoc;

    public GpelClient(URI autoDicoveryLocation, GcHttpTransport transport) throws GcException {
        if (autoDicoveryLocation == null) {
            throw new IllegalArgumentException();
        }
        if (transport == null) {
            throw new IllegalArgumentException();
        }
        this.transport = transport;
        this.introspectLocation(autoDicoveryLocation);
    }

    public GcHttpTransport getTransport() {
        return this.transport;
    }

    public GcHttpTransport requireSecureTransport() {
        return this.getTransport();
    }

    public void setFilter(GcLinkFilter filter) {
        this.filter = filter;
    }

    public GcLinkFilter getFilter() {
        return this.filter;
    }

    public URI getApiPostLocation() throws GcException {
        return this.gpelNewPostLocation;
    }

    public URI mapIdToLocation(URI maybeId) {
        return this.mapIdToKnownLocation(maybeId, this.gpelSpaceLoc);
    }

    public URI mapIdToKnownLocation(URI maybeId, URI spaceLoc) {
        String id;
        URI loc = maybeId;
        if (maybeId.getScheme().equals("tag") && (id = maybeId.toString()).startsWith(this.gpelSpaceGuid)) {
            String path = id.substring(this.gpelSpaceGuid.length());
            if (!path.endsWith(".atom")) {
                path = path + ".atom";
            }
            loc = URI.create(spaceLoc + path);
        }
        return loc;
    }

    public URI mapLocationToId(URI uri) {
        URI id;
        String spaceLoc;
        String uriAsString = uri.toString();
        if (uriAsString.startsWith(spaceLoc = this.gpelSpaceLoc.toString())) {
            String path = uriAsString.substring(spaceLoc.length());
            if (path.endsWith(".atom")) {
                path = path.substring(0, path.length() - ".atom".length());
            }
            id = URI.create(this.gpelSpaceGuid + path);
        } else if (uriAsString.startsWith(this.gpelSpaceGuid)) {
            id = uri;
        } else {
            throw new GcException("could not map " + uri + " to id" + " (known locations " + spaceLoc + " ) ");
        }
        return id;
    }

    public GcTemplate createTemplate(String title) throws GcException {
        return new GcTemplate(this, title, this.filter);
    }

    public GcSearchList findTemplates(int num) throws GcException {
        GcSearchRequest req = new GcSearchRequest(num);
        return this.findTemplates(req);
    }

    public GcSearchList findTemplates(int num, GcSearchRequest.SearchType st) throws GcException {
        GcSearchRequest req = new GcSearchRequest(num);
        req.setSearchType(st);
        return this.findTemplates(req);
    }

    public GcSearchList findTemplates(GcSearchRequest req) throws GcException {
        if (req.size() <= 0) {
            throw new IllegalArgumentException();
        }
        String queryLoc = this.getApiPostLocation() + "/?action=search&type=gpel-template&num=" + req.size();
        XmlElement feed = this.getTransport().getXml(URI.create(queryLoc));
        GcSearchListImpl results = new GcSearchListImpl();
        for (XmlElement entry : feed.elements(GpelConstants.ATOM_NS, "entry")) {
            XmlElement titleEl;
            String title = null;
            URI id = null;
            long lastModfied = -1L;
            XmlElement idEl = entry.element(GpelConstants.ATOM_NS, "id");
            if (idEl != null) {
                id = URI.create(idEl.requiredText());
            }
            if ((titleEl = entry.element(GpelConstants.ATOM_NS, "title")) != null) {
                title = titleEl.requiredText();
            }
            GcSearchResultImpl hit = new GcSearchResultImpl(id, title, lastModfied);
            results.addResult(hit);
        }
        return results;
    }

    public GcTemplate retrieveTemplate(URI location) throws GcException {
        GcTemplate t = (GcTemplate)this.loadResource(location);
        t.setClient(this);
        t.setFilter(this.filter);
        t.loadResourcesFromLinks();
        return t;
    }

    public void deployTemplate(GcTemplate t) throws GcException {
        t.saveLinkedResources();
    }

    public void storeInstance(GcInstance wfi) {
        wfi.saveLinkedResources();
    }

    public GcInstance createInstance(GcTemplate template) {
        URI tloc = this.mapIdToLocation(template.getTemplateId());
        URI loc = URI.create(tloc.toString() + "?action=gpel-create-instance");
        logger.finest("loc=" + loc);
        GcHttpRequest.Method httpMethod = GcHttpRequest.Method.POST;
        GcHttpRequest req = new GcHttpRequest(httpMethod, loc, "application/atom+xml; charset=utf-8", builder.newFragment(GcUtil.ATOM_NS, "entry"));
        GcHttpResponse resp = this.requireSecureTransport().perform(req);
        if (!resp.hasContent()) {
            throw new GcException("expected XML result when POSTing to " + loc);
        }
        GcInstance instance = (GcInstance)this.resFromHttp.createResourceFromHttp(resp, null);
        instance.setLocation(resp.getLocation());
        instance.setClient(this);
        instance.setFilter(this.filter);
        instance.loadResourcesFromLinks();
        return instance;
    }

    public GcInstance retrieveInstance(URI location) {
        GcInstance instance = (GcInstance)this.loadResource(location);
        instance.setClient(this);
        instance.setFilter(this.filter);
        instance.loadResourcesFromLinks();
        return instance;
    }

    public void storeResource(GcWebResource resource) throws GcException {
        GcHttpRequest.Method httpMethod;
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        URI loc = resource.getLocation();
        if (loc == null) {
            httpMethod = GcHttpRequest.Method.POST;
            loc = this.getApiPostLocation();
        } else {
            httpMethod = GcHttpRequest.Method.PUT;
        }
        assert (loc != null);
        GcHttpRequest req = this.resToHttp.transformResourceToHttpRequest(httpMethod, loc, resource);
        GcHttpResponse resp = this.requireSecureTransport().perform(req);
        if (resp.hasContent()) {
            throw new GcException("Unexpected content when storing resource to " + loc);
        }
        if (httpMethod == GcHttpRequest.Method.POST) {
            URI newLoc = resp.getLocation();
            GcWebResource newRes = this.loadResource(newLoc);
            ((GcAtomResource)resource).xmlSet(((GcAtomResource)newRes).xml());
        }
        resource.setLocation(resp.getLocation());
    }

    public GcWebResource loadResource(URI location) throws GcException {
        return this.loadResource(location, null);
    }

    public GcWebResource loadResource(URI loc, String rel) throws GcException {
        if (loc == null) {
            throw new IllegalArgumentException();
        }
        URI location = this.mapIdToLocation(loc);
        GcHttpRequest.Method met = GcHttpRequest.Method.GET;
        GcHttpRequest req = new GcHttpRequest(GcHttpRequest.Method.GET, location);
        GcHttpResponse resp = this.getTransport().perform(req);
        if (!resp.hasContent()) {
            throw new GcException("no resource for " + loc + "(mapped to " + location + ")");
        }
        GcWebResource resource = this.resFromHttp.createResourceFromHttp(resp, rel);
        resource.setLocation(resp.getLocation());
        if (rel != null) {
            resource.setRel(rel);
        }
        return resource;
    }

    private void introspectLocation(URI autoDicoveryLocation) throws GcException {
        XmlElement xhtml = this.getTransport().getXml(autoDicoveryLocation);
        XmlElement head = xhtml.requiredElement("head");
        for (XmlElement link : head.elements(null, "link")) {
            String rel = link.attributeValue("rel");
            String href = link.attributeValue("href");
            if ("gpel.space.post".equals(rel) && href != null) {
                this.gpelNewPostLocation = URI.create(href);
            }
            if ("gpel.space.guid".equals(rel) && href != null) {
                this.gpelSpaceGuid = href;
            }
            if (!"gpel.space.loc".equals(rel) || href == null) continue;
            this.gpelSpaceLoc = URI.create(href);
        }
    }

    public void setResourceFromHttpFactory(GcWebResourceFromHttp resFromHttp) {
        this.resFromHttp = resFromHttp;
    }

    public GcWebResourceFromHttp getResourceFromHttpFactory() {
        return this.resFromHttp;
    }

    public void setResourceToHttpFactory(GcWebResourceToHttp resToHttp) {
        this.resToHttp = resToHttp;
    }

    public GcWebResourceToHttp getResourceToHttpFactory() {
        return this.resToHttp;
    }

    static class GcSearchResultImpl
    implements GcSearchResult {
        private URI id;
        private String title;
        private long lastModfied;

        public GcSearchResultImpl(URI id, String title, long lastModfied) {
            this.title = title;
            this.id = id;
            this.lastModfied = lastModfied;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public URI getId() {
            return this.id;
        }

        @Override
        public long getLastModfied() {
            return this.lastModfied;
        }
    }

    static class GcSearchListImpl
    implements GcSearchList {
        private List<GcSearchResult> list = new ArrayList<GcSearchResult>();

        GcSearchListImpl() {
        }

        public void addResult(GcSearchResult hit) {
            this.list.add(hit);
        }

        @Override
        public Iterable<GcSearchResult> results() {
            return this.list;
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }
}

