/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.client.http;

import org.gpel.GpelConstants;
import org.gpel.client.GcAtomResource;
import org.gpel.client.GcBinaryWebResource;
import org.gpel.client.GcException;
import org.gpel.client.GcIncomingQueue;
import org.gpel.client.GcInstance;
import org.gpel.client.GcOutgoingQueue;
import org.gpel.client.GcProcessResource;
import org.gpel.client.GcProvidesWsdlResource;
import org.gpel.client.GcState;
import org.gpel.client.GcTemplate;
import org.gpel.client.GcTextWebResource;
import org.gpel.client.GcUsesWsdlResource;
import org.gpel.client.GcUtil;
import org.gpel.client.GcWebResource;
import org.gpel.client.GcWebResourceType;
import org.gpel.client.GcWsdlResource;
import org.gpel.client.GcXmlWebResource;
import org.gpel.client.http.GcHttpResponse;
import org.gpel.client.http.GcWebResourceFromHttp;
import org.gpel.client.util.base64.Base64;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlInfosetBuilder;
import org.xmlpull.infoset.view.XmlValidationException;

public class GcDefaultWebResourceFromHttp
implements GcWebResourceFromHttp {
    private static final XmlInfosetBuilder builder = GpelConstants.BUILDER;

    public static GcDefaultWebResourceFromHttp getInstance() {
        return new GcDefaultWebResourceFromHttp();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GcWebResource createResourceFromHttp(GcHttpResponse resp, String rel) throws GcException {
        XmlElement contentEl;
        XmlElement titleEl;
        XmlElement el;
        String contentType = resp.getContentType();
        GcWebResource resource = null;
        GcWebResourceType resType = GcUtil.categorizeContentType(contentType);
        String title = "No title";
        if (GcWebResourceType.XML.equals((Object)resType) && (el = resp.getXmlContent()).getNamespace().equals(GcUtil.ATOM_NS) && el.getName().equals("entry")) {
            GcWebResourceType atomResType;
            titleEl = el.element(GcUtil.ATOM_NS, "title");
            if (titleEl == null) {
                throw new XmlValidationException("missing atom:title in " + builder.serializeToString((Object)el));
            }
            title = titleEl.requiredText();
            contentEl = el.element(GcUtil.ATOM_NS, "content");
            if (contentEl == null) throw new IllegalStateException("missing atom:content");
            String atomContType = contentEl.attributeValue("type");
            if (atomContType != null) {
                contentType = atomContType;
            }
            if (GcWebResourceType.XML.equals((Object)(atomResType = GcUtil.categorizeContentType(atomContType)))) {
                resource = new GcXmlWebResource(el);
            } else if (GcWebResourceType.TEXT.equals((Object)atomResType)) {
                resource = new GcTextWebResource(el);
            } else {
                if (!GcWebResourceType.BINARY.equals((Object)atomResType)) throw new IllegalStateException("" + (Object)((Object)atomResType));
                resource = new GcBinaryWebResource(el);
            }
        }
        if (resource == null) {
            XmlElement atomEl = builder.newFragment(GcUtil.ATOM_NS, "entry");
            titleEl = atomEl.addElement(GcUtil.ATOM_NS, "title");
            contentEl = atomEl.addElement(GcUtil.ATOM_NS, "content");
            contentEl.setAttributeValue("type", contentType);
            if (GcWebResourceType.XML.equals((Object)resType)) {
                XmlElement el2 = resp.getXmlContent();
                contentEl.addChild((Object)el2);
                resource = new GcXmlWebResource(atomEl);
            } else if (GcWebResourceType.TEXT.equals((Object)resType)) {
                String text = resp.getTextContent();
                if (text == null) {
                    throw new IllegalStateException("missing text content");
                }
                contentEl.addChild((Object)text);
                resource = new GcTextWebResource(atomEl);
            } else {
                if (!GcWebResourceType.BINARY.equals((Object)resType)) throw new GcException("unsupported content type " + contentType);
                byte[] binary = resp.getBinaryContent();
                String s = new String(Base64.encode(binary));
                contentEl.addChild((Object)s);
                resource = new GcBinaryWebResource(atomEl);
            }
            titleEl.setText(title);
        }
        resource.setMimeType(contentType);
        String mimeType = resource.getMimeType();
        if (mimeType.equals("application/x-gpel+xml")) {
            return new GcProcessResource(((GcAtomResource)resource).xml());
        }
        if (mimeType.equals("application/wsdl+xml")) {
            XmlElement resXml = ((GcAtomResource)resource).xml();
            if (rel == null) return new GcWsdlResource(resXml);
            if (rel.equals("http://schemas.gpel.org/2005/grid-process/wsdl")) {
                return new GcWsdlResource(resXml);
            }
            if (rel.equals("http://schemas.gpel.org/2005/grid-process/uses-wsdl")) {
                return new GcUsesWsdlResource(resXml);
            }
            if (!rel.equals("http://schemas.gpel.org/2005/grid-process/provides-wsdl")) throw new GcException("unsupported rel " + rel + " for WSDl resource " + resp);
            return new GcProvidesWsdlResource(resXml);
        }
        if (mimeType.equals("application/x-gpel-template+xml")) {
            return new GcTemplate(((GcAtomResource)resource).xml());
        }
        if (mimeType.equals("application/x-gpel-instance+xml")) {
            return new GcInstance(((GcAtomResource)resource).xml());
        }
        if (mimeType.equals("application/x-gpel-state+xml")) {
            return new GcState(((GcAtomResource)resource).xml());
        }
        if (mimeType.equals("application/x-gpel-incoming-queue+xml")) {
            return new GcIncomingQueue(((GcAtomResource)resource).xml());
        }
        if (!mimeType.equals("application/x-gpel-outgoing-queue+xml")) return resource;
        return new GcOutgoingQueue(((GcAtomResource)resource).xml());
    }
}

