/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.client.http.apache_http_client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.gpel.GpelConstants;
import org.gpel.GpelVersion;
import org.gpel.client.GcException;
import org.gpel.client.GcResourceNotFoundException;
import org.gpel.client.GcUtil;
import org.gpel.client.GcWebResourceType;
import org.gpel.client.GpelUserCredentials;
import org.gpel.client.http.GcHttpException;
import org.gpel.client.http.GcHttpRequest;
import org.gpel.client.http.GcHttpResponse;
import org.gpel.client.http.GcHttpTransport;
import org.gpel.logger.GLogger;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlInfosetBuilder;

public class Transport
implements GcHttpTransport {
    private static final XmlInfosetBuilder builder = GpelConstants.BUILDER;
    private static final GLogger logger = GLogger.getLogger();
    private HttpClient secureClient;
    private HttpClient unsecureClient = new HttpClient();
    private GpelUserCredentials userCredentials;

    public Transport() {
    }

    public Transport(GpelUserCredentials credentials) {
        this();
        if (credentials == null) {
            throw new IllegalArgumentException();
        }
        this.userCredentials = credentials;
    }

    @Override
    public XmlElement getXml(URI location) throws GcException {
        return this.getXml(location, true);
    }

    public HttpClient getClientForLocation(URI location) throws GcHttpException {
        String scheme = location.getScheme();
        if (this.secureClient != null && "https".equals(scheme)) {
            return this.secureClient;
        }
        return this.unsecureClient;
    }

    @Override
    public XmlElement getXml(URI location, boolean withBasicAuthz) throws GcHttpException {
        GetMethod get = new GetMethod(location.toString());
        get.setRequestHeader("User-Agent", GpelVersion.getUserAgent());
        try {
            XmlElement el;
            HttpClient client = this.getClientForLocation(location);
            if (withBasicAuthz) {
                this.requireCredentials(client, (HttpMethod)get, location);
            }
            client.executeMethod((HttpMethod)get);
            String responseBody = get.getResponseBodyAsString();
            XmlElement xmlElement = el = builder.parseFragmentFromString(responseBody);
            return xmlElement;
        }
        catch (IOException e) {
            throw new GcException("HTTP transport get XML failed for " + location + " (withBasicAuthz=" + withBasicAuthz + ")", e);
        }
        finally {
            get.releaseConnection();
        }
    }

    @Override
    public GcHttpResponse perform(GcHttpRequest req) throws GcHttpException {
        HttpMethod method;
        try {
            method = this.createHttpMethodFor(req);
        }
        catch (IllegalStateException e) {
            throw new GcHttpException("failed to create HTTP method for " + req, e);
        }
        try {
            HttpClient client = this.getClientForLocation(req.getLocation());
            if (req.useAuthz()) {
                this.requireCredentials(client, method, req.getLocation());
            }
            client.executeMethod(method);
            GcHttpResponse gcHttpResponse = this.extractResponse(req, method);
            return gcHttpResponse;
        }
        catch (IOException e) {
            throw new GcHttpException("HTTP transport failed accessing " + req.getLocation(), e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private HttpMethod createHttpMethodFor(GcHttpRequest req) throws GcHttpException {
        GetMethod method;
        String location = req.getLocation().toString();
        GcHttpRequest.Method met = req.getMethod();
        if (GcHttpRequest.Method.GET.equals((Object)met)) {
            method = new GetMethod(location);
        } else if (GcHttpRequest.Method.PUT.equals((Object)req.getMethod())) {
            method = new PutMethod(location);
        } else if (GcHttpRequest.Method.POST.equals((Object)req.getMethod())) {
            method = new PostMethod(location);
        } else {
            throw new GcHttpException("unknown method " + (Object)((Object)met));
        }
        method.setRequestHeader("User-Agent", GpelVersion.getUserAgent());
        if (req.hasContent()) {
            byte[] binary;
            ByteArrayInputStream input;
            long contentLength = -1L;
            if (req.getXmlContent() != null) {
                byte[] binary2;
                String string = builder.serializeToString((Object)req.getXmlContent());
                try {
                    binary2 = string.getBytes("UTF8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new GcHttpException("could not get text content as UTF8", e);
                }
                contentLength = binary2.length;
                input = new ByteArrayInputStream(binary2);
            } else if (req.getTextContent() != null) {
                try {
                    binary = req.getTextContent().getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new GcHttpException("could not get text content as UTF8", e);
                }
                contentLength = binary.length;
                input = new ByteArrayInputStream(binary);
            } else if (req.getBinaryContent() != null) {
                binary = req.getBinaryContent();
                contentLength = binary.length;
                input = new ByteArrayInputStream(binary);
            } else {
                throw new IllegalStateException("content missing");
            }
            EntityEnclosingMethod emet = (EntityEnclosingMethod)method;
            emet.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)input, contentLength, req.getContentType()));
        }
        return method;
    }

    private void requireCredentials(HttpClient client, HttpMethod method, URI locationUri) {
        if (this.userCredentials != null) {
            client.getParams().setAuthenticationPreemptive(true);
            method.setDoAuthentication(true);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.userCredentials.getUserName(), this.userCredentials.getUserPassword());
            client.getState().setCredentials(new AuthScope(locationUri.getHost(), locationUri.getPort()), (Credentials)credentials);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private GcHttpResponse extractResponse(GcHttpRequest req, HttpMethod method) throws GcHttpException {
        try {
            int statusCode = method.getStatusCode();
            if (statusCode != 200 && statusCode != 201 && statusCode != 202) {
                String responseBody = method.getResponseBodyAsString();
                String extraInfo = "";
                if (responseBody != null) {
                    extraInfo = "\n" + responseBody;
                }
                if (statusCode != 404) throw new GcHttpException("HTTP failed with status " + statusCode + " (" + method.getStatusLine() + ")" + extraInfo);
                throw new GcResourceNotFoundException("could not get resource from " + req.getLocation() + extraInfo, req.getLocation());
            }
            URI location = URI.create(method.getURI().toString());
            if (method.getResponseHeader("Location") != null) {
                String locationRedirect = method.getResponseHeader("Location").getValue();
                location = URI.create(locationRedirect);
            }
            String contentType = null;
            if (method.getResponseHeader("Content-type") == null) return new GcHttpResponse(location);
            contentType = method.getResponseHeader("Content-type").getValue();
            GcWebResourceType cat = GcUtil.categorizeContentType(contentType);
            if (cat != GcWebResourceType.XML) throw new IllegalStateException("unsupported " + (Object)((Object)cat));
            byte[] responseBody = method.getResponseBody();
            logger.finest("responseBody=" + new String(responseBody, "UTF8"));
            XmlElement el = builder.parseFragmentFromInputStream((InputStream)new ByteArrayInputStream(responseBody));
            return new GcHttpResponse(location, contentType, el);
        }
        catch (IOException e) {
            throw new GcHttpException("HTTP transport response processing failed", e);
        }
    }

    public static class TrustedListX509TrustManager
    implements X509TrustManager {
        private X509Certificate[] trustedCerts;

        public TrustedListX509TrustManager(X509Certificate[] trustedCerts) {
            if (trustedCerts == null || trustedCerts.length == 0) {
                throw new IllegalArgumentException();
            }
            this.trustedCerts = trustedCerts;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustedCerts;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            this.checkTrusted(certs, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            this.checkTrusted(certs, authType);
        }

        private void checkTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            if (certs == null || certs.length == 0) {
                throw new CertificateException("missing certificate chain to verify");
            }
            X509Certificate firstCert = certs[0];
            firstCert.checkValidity();
            Collection<List<?>> names = firstCert.getSubjectAlternativeNames();
            for (int i = 1; i < certs.length; ++i) {
                X509Certificate cert = certs[i];
                cert.checkValidity();
                Principal principalSubject = cert.getSubjectDN();
                X509Certificate prevCert = certs[i - 1];
                Principal prevPrincipalIssuer = prevCert.getIssuerDN();
                if (!principalSubject.equals(prevPrincipalIssuer)) {
                    throw new CertificateException("certificate chain invalid: issuer " + prevPrincipalIssuer + " is not the same as next certificate subject " + principalSubject + " (previous=" + prevCert + " current=" + cert + ")");
                }
                try {
                    prevCert.verify(cert.getPublicKey());
                    continue;
                }
                catch (InvalidKeyException e) {
                    throw new CertificateException(e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new CertificateException(e);
                }
                catch (NoSuchProviderException e) {
                    throw new CertificateException(e);
                }
                catch (SignatureException e) {
                    throw new CertificateException(e);
                }
            }
            X509Certificate lastCertificateInChain = certs[certs.length - 1];
            for (int i = 0; i < this.trustedCerts.length; ++i) {
                X509Certificate trustedCert = this.trustedCerts[i];
                try {
                    trustedCert.checkValidity();
                    lastCertificateInChain.verify(trustedCert.getPublicKey());
                    return;
                }
                catch (CertificateExpiredException e) {
                    continue;
                }
                catch (InvalidKeyException e) {
                    continue;
                }
                catch (NoSuchAlgorithmException e) {
                    continue;
                }
                catch (NoSuchProviderException e) {
                    continue;
                }
                catch (SignatureException e) {
                    // empty catch block
                }
            }
            throw new CertificateException("could not find trusted CA to verify " + lastCertificateInChain);
        }
    }

    public static class OneChainKeyManager
    extends X509ExtendedKeyManager {
        private X509Certificate[] certChain;
        private PrivateKey privateKey;

        public OneChainKeyManager(X509Certificate[] certChain, PrivateKey privateKey) {
            if (certChain == null || certChain.length == 0) {
                throw new IllegalArgumentException();
            }
            this.certChain = certChain;
            if (privateKey == null) {
                throw new IllegalArgumentException();
            }
            this.privateKey = privateKey;
        }

        @Override
        public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
            return "default";
        }

        @Override
        public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String arg0) {
            return this.certChain;
        }

        @Override
        public String[] getClientAliases(String arg0, Principal[] arg1) {
            return new String[]{"default"};
        }

        @Override
        public PrivateKey getPrivateKey(String arg0) {
            return this.privateKey;
        }

        @Override
        public String[] getServerAliases(String arg0, Principal[] arg1) {
            return null;
        }
    }

    public static class TrustAllX509TrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }

    private static class LimitedTrustSSLProtocolSocketFactory
    implements SecureProtocolSocketFactory {
        private SSLContext sslcontext = SSLContext.getInstance("TLS");

        public LimitedTrustSSLProtocolSocketFactory(KeyManager[] kms, TrustManager[] trustCerts) throws KeyManagementException, NoSuchAlgorithmException {
            this.sslcontext.init(kms, trustCerts, null);
        }

        private SSLContext getSSLContext() {
            return this.sslcontext;
        }

        public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            if (params == null) {
                throw new IllegalArgumentException("Parameters may not be null");
            }
            int timeout = params.getConnectionTimeout();
            if (timeout == 0) {
                return this.createSocket(host, port, localAddress, localPort);
            }
            return ControllerThreadSocketFactory.createSocket((ProtocolSocketFactory)this, (String)host, (int)port, (InetAddress)localAddress, (int)localPort, (int)timeout);
        }

        public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
            SSLSocket socket = (SSLSocket)this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
            return socket;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket(host, port);
        }

        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
        }
    }
}

