/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.client.util.base64;

import org.gpel.client.util.base64.Base64DecodingException;
import org.gpel.client.util.base64.Base64DecodingState;
import org.gpel.client.util.base64.Base64EncodingException;
import org.gpel.client.util.base64.Base64EncodingState;

public class Base64 {
    private static final char[] base64alphabet;
    private static byte[] base64lookup;

    public static byte[] decode(Base64DecodingState state, char[] data, int off, int len, boolean finalize) throws Base64DecodingException {
        try {
            int i;
            int inputEnd = 0;
            byte[] input = new byte[4];
            if (state != null) {
                inputEnd = state.inputEnd;
                for (int i2 = 0; i2 < state.input.length; ++i2) {
                    input[i2] = state.input[i2];
                }
            }
            int end = off + len;
            for (i = off; i < end; ++i) {
                if (Character.isWhitespace(data[i])) continue;
                off = i;
                break;
            }
            for (i = end - 1; i > off; --i) {
                if (Character.isWhitespace(data[i])) continue;
                end = i + 1;
                break;
            }
            len = end - off;
            long dataBits = 6 * (len + inputEnd);
            long bytesToOutputLong = dataBits / 8L;
            int bytesToOutput = (int)bytesToOutputLong;
            byte[] b = new byte[bytesToOutput];
            int bytesSoFar = 0;
            for (int i3 = off; i3 < end; ++i3) {
                char ch = data[i3];
                if (Character.isWhitespace(ch)) continue;
                if (ch != '=') {
                    char val = ch;
                    if (val > '\u007f') {
                        throw new Base64DecodingException("invalid base64 encoding character > 127 '" + ch + "''");
                    }
                    byte bv = base64lookup[val];
                    if (bv == -1) {
                        throw new Base64DecodingException("invalid base64 encoding character '" + ch + "''");
                    }
                    input[inputEnd++] = bv;
                }
                if (inputEnd == 4) {
                    inputEnd = 0;
                    b[bytesSoFar++] = (byte)(input[0] << 2 | input[1] >> 4);
                    b[bytesSoFar++] = (byte)((input[1] & 0xF) << 4 | input[2] >> 2 & 0xF);
                    b[bytesSoFar++] = (byte)(input[2] << 6 | input[3]);
                    continue;
                }
                if (ch != '=') continue;
                finalize = true;
                if (inputEnd == 3) {
                    b[bytesSoFar++] = (byte)(input[0] << 2 | input[1] >> 4);
                    b[bytesSoFar++] = (byte)((input[1] & 0xF) << 4 | input[2] >> 2 & 0xF);
                } else if (inputEnd == 2) {
                    b[bytesSoFar++] = (byte)(input[0] << 2 | input[1] >> 4);
                } else {
                    throw new Base64DecodingException("end marker in wrong place to finish decoding base64");
                }
                inputEnd = 0;
                break;
            }
            if (finalize && inputEnd != 0) {
                throw new Base64DecodingException("missing base64 encoded data");
            }
            if (bytesSoFar < b.length) {
                byte[] bb = new byte[bytesSoFar];
                System.arraycopy(b, 0, bb, 0, bb.length);
                b = bb;
            }
            return b;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new Base64DecodingException("illegal internal state", e);
        }
    }

    public static byte[] decode(char[] data, int off, int len) throws Base64DecodingException {
        return Base64.decode(null, data, off, len, true);
    }

    public static byte[] decode(char[] data) throws Base64DecodingException {
        return Base64.decode(data, 0, data.length);
    }

    public static char[] encode(Base64EncodingState state, byte[] data, int off, int len, boolean finalize) throws Base64EncodingException {
        try {
            int outputEnd = 0;
            int[] output = new int[4];
            if (state != null) {
                outputEnd = state.outputEnd;
                for (int i = 0; i < state.output.length; ++i) {
                    output[i] = state.output[i];
                }
            }
            int end = off + len;
            long dataTriples = (len + outputEnd + 2) / 3;
            long charsToOutputLong = 4L * dataTriples;
            if (charsToOutputLong > Integer.MAX_VALUE) {
                throw new Base64EncodingException("input data is too big to output in one char array");
            }
            int charsToOutput = (int)charsToOutputLong;
            char[] b = new char[charsToOutput];
            int charsSoFar = 0;
            for (int i = off; i < end; ++i) {
                output[outputEnd++] = data[i] & 0xFF;
                if (outputEnd != 3) continue;
                outputEnd = 0;
                b[charsSoFar++] = base64alphabet[output[0] >> 2];
                b[charsSoFar++] = base64alphabet[(output[0] & 3) << 4 | output[1] >> 4];
                b[charsSoFar++] = base64alphabet[(output[1] & 0xF) << 2 | output[2] >> 6];
                b[charsSoFar++] = base64alphabet[output[2] & 0x3F];
            }
            if (finalize) {
                if (outputEnd == 2) {
                    b[charsSoFar++] = base64alphabet[output[0] >> 2];
                    b[charsSoFar++] = base64alphabet[(output[0] & 3) << 4 | output[1] >> 4];
                    b[charsSoFar++] = base64alphabet[(output[1] & 0xF) << 2];
                    b[charsSoFar++] = 61;
                } else if (outputEnd == 1) {
                    b[charsSoFar++] = base64alphabet[output[0] >> 2];
                    int t = output[0] & 3;
                    b[charsSoFar++] = base64alphabet[t <<= 4];
                    b[charsSoFar++] = 61;
                    b[charsSoFar++] = 61;
                }
            }
            return b;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new Base64EncodingException("illegal internal state", e);
        }
    }

    public static char[] encode(byte[] data, int off, int len) throws Base64EncodingException {
        return Base64.encode(null, data, off, len, true);
    }

    public static char[] encode(byte[] data) throws Base64EncodingException {
        return Base64.encode(data, 0, data.length);
    }

    static {
        int i;
        base64alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        base64lookup = new byte[128];
        if (base64alphabet.length != 64) {
            throw new IllegalStateException();
        }
        for (i = 0; i < 128; ++i) {
            Base64.base64lookup[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64.base64lookup[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64.base64lookup[i] = (byte)(i - 97 + 26);
        }
        for (i = 48; i <= 57; ++i) {
            Base64.base64lookup[i] = (byte)(i - 48 + 52);
        }
        Base64.base64lookup[43] = 62;
        Base64.base64lookup[47] = 63;
    }
}

