/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.model;

import org.gpel.GpelConstants;
import org.gpel.model.GpelAssign;
import org.gpel.model.GpelElse;
import org.gpel.model.GpelElseIf;
import org.gpel.model.GpelFlow;
import org.gpel.model.GpelForEach;
import org.gpel.model.GpelIf;
import org.gpel.model.GpelInvoke;
import org.gpel.model.GpelModelBase;
import org.gpel.model.GpelModelValidationException;
import org.gpel.model.GpelReceive;
import org.gpel.model.GpelReply;
import org.gpel.model.GpelScope;
import org.gpel.model.GpelSequence;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;

public abstract class GpelActivity
extends GpelModelBase {
    private static final String INTERNAL_STMT_ID_ATTR = "statementId";
    private static final String NAME_ATTR = "name";

    public GpelActivity(String typeName, XmlElement target) {
        super(typeName, target);
    }

    public GpelActivity(XmlNamespace ns, String typeName) {
        super(ns, typeName);
    }

    public void setInternalStatementId(String stmtId) {
        this.xml.setAttributeValue(GpelConstants.GPEL_NS, INTERNAL_STMT_ID_ATTR, stmtId);
    }

    public String getInternalStatementId() {
        return this.xml.attributeValue(GpelConstants.GPEL_NS, INTERNAL_STMT_ID_ATTR);
    }

    public static GpelActivity convertElementToActivity(XmlElement el) throws GpelModelValidationException {
        GpelActivity activity = GpelActivity.convertElementToActivityIfPossible(el);
        if (activity == null) {
            throw new GpelModelValidationException("could not make into activity this element " + builder.serializeToString((Object)el));
        }
        return activity;
    }

    public static GpelActivity convertElementToActivityIfPossible(XmlElement el) throws GpelModelValidationException {
        XmlNamespace ns = el.getNamespace();
        String name = el.getName();
        if ("invoke".equals(name)) {
            return (GpelActivity)el.viewAs(GpelInvoke.class);
        }
        if ("receive".equals(name)) {
            return (GpelActivity)el.viewAs(GpelReceive.class);
        }
        if ("reply".equals(name)) {
            return (GpelActivity)el.viewAs(GpelReply.class);
        }
        if ("assign".equals(name)) {
            return (GpelActivity)el.viewAs(GpelAssign.class);
        }
        if ("flow".equals(name)) {
            return (GpelActivity)el.viewAs(GpelFlow.class);
        }
        if ("sequence".equals(name)) {
            return (GpelActivity)el.viewAs(GpelSequence.class);
        }
        if ("if".equals(name)) {
            return (GpelActivity)el.viewAs(GpelIf.class);
        }
        if ("else".equals(name)) {
            return (GpelActivity)el.viewAs(GpelElse.class);
        }
        if ("elseif".equals(name)) {
            return (GpelActivity)el.viewAs(GpelElseIf.class);
        }
        if ("forEach".equals(name)) {
            return (GpelActivity)el.viewAs(GpelForEach.class);
        }
        if ("scope".equals(name)) {
            return (GpelActivity)el.viewAs(GpelScope.class);
        }
        return null;
    }

    public void setName(String name) {
        this.xml().setAttributeValue(NAME_ATTR, name);
    }

    public String getName() {
        return this.xml().attributeValue(NAME_ATTR);
    }
}

