/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.model;

import org.gpel.model.GpelContainerActivityOfOne;
import org.gpel.model.GpelModelException;
import org.gpel.model.GpelScope;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;

public class GpelForEach
extends GpelContainerActivityOfOne {
    public static final String TYPE_NAME = "forEach";
    public static final String COUNTER_NAME_ATTR = "counterName";
    public static final String PARALLEL_ATTR = "parallel";
    public static final String YES_PARALLEL = "yes";
    public static final String NO_PARALLEL = "no";
    public static final String START_COUNTER_VALUE_EL = "startCounterValue";
    public static final String FINAL_COUNTER_VALUE_EL = "finalCounterValue";

    public GpelForEach(XmlElement target) {
        super(TYPE_NAME, target);
    }

    public GpelForEach(XmlNamespace NS, String counterName, String startCounterValue, String finalCounterValue, boolean isParallel, GpelScope scope) {
        super(NS, TYPE_NAME);
        if (counterName == null) {
            throw new IllegalArgumentException();
        }
        if (startCounterValue == null) {
            throw new IllegalArgumentException();
        }
        if (finalCounterValue == null) {
            throw new IllegalArgumentException();
        }
        this.xml().setAttributeValue(COUNTER_NAME_ATTR, counterName);
        this.xml().setAttributeValue(PARALLEL_ATTR, isParallel ? YES_PARALLEL : NO_PARALLEL);
        this.xml().addElement(this.xml().getNamespace(), START_COUNTER_VALUE_EL).setText(startCounterValue);
        this.xml().addElement(this.xml().getNamespace(), FINAL_COUNTER_VALUE_EL).setText(finalCounterValue);
        this.setActivity(scope);
    }

    public String getCounterName() {
        return this.xml().requiredAttributeValue(COUNTER_NAME_ATTR);
    }

    public String getStartCounterValue() {
        return this.xml().requiredElement(this.xml().getNamespace(), START_COUNTER_VALUE_EL).requiredText();
    }

    public String getFinalCounterValue() {
        return this.xml().requiredElement(this.xml().getNamespace(), FINAL_COUNTER_VALUE_EL).requiredText();
    }

    public boolean isParallel() {
        String val = this.xml().requiredAttributeValue(PARALLEL_ATTR);
        if (YES_PARALLEL.equals(val)) {
            return true;
        }
        if (NO_PARALLEL.equals(val)) {
            return false;
        }
        throw new GpelModelException("Expected yes or no but got " + val + " in " + this.xmlString());
    }
}

