/*
 * Decompiled with CFR 0.152.
 */
package org.gpel.model;

import javax.xml.namespace.QName;
import org.gpel.GpelConstants;
import org.gpel.logger.GLogger;
import org.gpel.model.GpelActivity;
import org.gpel.model.GpelModelBase;
import org.gpel.model.GpelModelValidationException;
import org.gpel.model.GpelPartnerLink;
import org.gpel.model.GpelPartnerLinksContainer;
import org.gpel.model.GpelSequence;
import org.gpel.model.GpelVariable;
import org.gpel.model.GpelVariablesContainer;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.view.XmlValidationException;

public class GpelProcess
extends GpelModelBase {
    private static final GLogger logger = GLogger.getLogger();
    public static final String TYPE_NAME = "process";
    private static final String TARGET_NAMESPACE = "targetNamespace";
    private int counter = 1;

    public GpelProcess(XmlElement target) {
        super(TYPE_NAME, target);
    }

    public GpelProcess(XmlNamespace docNS, String targetNamespaceUri) {
        super(docNS, TYPE_NAME);
        GpelConstants.GPEL_NS = docNS;
        this.xml().declareNamespace(GpelConstants.GPEL_NS);
        this.setTargetNamespace(targetNamespaceUri);
    }

    public GpelVariablesContainer getVariables() throws GpelModelValidationException {
        XmlElement el = this.xml().element(this.xml().getNamespace(), "variables");
        if (el == null) {
            el = this.xml().addElement(builder.newFragment(NS, "variables"));
        }
        GpelVariablesContainer variables = (GpelVariablesContainer)el.viewAs(GpelVariablesContainer.class);
        return variables;
    }

    public void setVariables(GpelVariablesContainer variables) throws GpelModelValidationException {
        XmlElement el = this.xml().element(null, "variables");
        if (el != null) {
            this.xml().removeChild((Object)el);
        }
        this.xml().addElement(variables.xml());
    }

    public void addMessageVariable(String varName, XmlNamespace msgTypeNs, String msgTypeLocalName) {
        GpelVariable var = new GpelVariable(NS, varName);
        this.getVariables().xml().addElement(var.xml());
        var.setMessageTypeQName(new QName(msgTypeNs.getName(), msgTypeLocalName, msgTypeNs.getPrefix()));
    }

    public GpelPartnerLinksContainer getPartnerLinks() throws GpelModelValidationException {
        XmlElement el = this.xml().element(this.xml().getNamespace(), "partnerLinks");
        if (el == null) {
            el = this.xml().addElement(builder.newFragment(NS, "partnerLinks"));
        }
        GpelPartnerLinksContainer partnerLinks = (GpelPartnerLinksContainer)el.viewAs(GpelPartnerLinksContainer.class);
        return partnerLinks;
    }

    public void addPartnerLink(String linkName, XmlNamespace partnerLinkTypeNs, String partnerLinkTypeName) {
        this.addPartnerLink(linkName, partnerLinkTypeNs, partnerLinkTypeName, null, null);
    }

    public void addPartnerLink(String linkName, XmlNamespace partnerLinkTypeNs, String partnerLinkTypeName, String myRole, String partnerRole) {
        GpelPartnerLink pl = new GpelPartnerLink(NS, linkName, partnerLinkTypeNs, partnerLinkTypeName);
        this.getPartnerLinks().xml().addElement(pl.xml());
        if (myRole != null) {
            pl.setMyRole(myRole);
        }
        if (partnerRole != null) {
            pl.setPartnerRole(partnerRole);
        }
    }

    public String getTargetNamespace() {
        return this.xml.attributeValue(TARGET_NAMESPACE);
    }

    public void setTargetNamespace(String targetNamespaceUri) {
        this.xml.setAttributeValue(TARGET_NAMESPACE, targetNamespaceUri);
    }

    public GpelActivity lookupActivity(String pos) throws GpelModelValidationException {
        GpelActivity topActivity = this.getActivity();
        GpelActivity result = this.lookupActivity(pos, topActivity);
        return result;
    }

    public GpelActivity lookupActivity(String pos, GpelActivity parent) throws GpelModelValidationException {
        String p = parent.getInternalStatementId();
        if (p == null) {
            p = "" + this.counter++;
            parent.setInternalStatementId(p);
        }
        if (pos.equals(p)) {
            return parent;
        }
        for (XmlElement el : parent.xml().requiredElementContent()) {
            GpelActivity result;
            GpelActivity childActivity = GpelActivity.convertElementToActivityIfPossible(el);
            if (childActivity == null || (result = this.lookupActivity(pos, childActivity)) == null) continue;
            return result;
        }
        return null;
    }

    public GpelActivity getActivity() throws GpelModelValidationException {
        for (XmlElement el : this.xml().requiredElementContent()) {
            String elName;
            XmlNamespace elNs = el.getNamespace();
            if (!elNs.equals(GpelConstants.BPEL_NS) && !elNs.equals(GpelConstants.GPEL_NS) || !(elName = el.getName()).equals("sequence")) continue;
            GpelSequence seq = (GpelSequence)el.viewAs(GpelSequence.class);
            return seq;
        }
        return null;
    }

    public void setActivity(GpelActivity activity) throws GpelModelValidationException {
        if (!(activity instanceof GpelSequence)) {
            throw new IllegalArgumentException("only sequence currently supported as main process activity");
        }
        if (this.getActivity() != null) {
            this.xml().removeChild((Object)this.getActivity().xml());
        }
        assert (this.getActivity() == null);
        this.xml().addElement(activity.xml());
    }

    public void xmlValidate() throws XmlValidationException {
        GpelActivity activity = this.getActivity();
        if (activity == null) {
            throw new XmlValidationException("missing required activity in " + this.xmlString());
        }
        activity.xmlValidate();
    }
}

