/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/* Copyright (c) 2005 Extreme! Lab, Indiana University. All rights reserved.
 * This software is open source. See the bottom of this file for the license.
 * $Id: GcLink.java,v 1.3 2006/12/07 04:55:28 aslom Exp $
 */
package org.gpel.client;



import java.net.URI;
import org.gpel.GpelConstants;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlInfosetBuilder;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.view.TypedXmlElementView;

public class GcLink extends TypedXmlElementView {
    private final static XmlInfosetBuilder builder = GpelConstants.BUILDER;
    
    public final static XmlNamespace TYPE_NS = GpelConstants.ATOM_NS;
    public final static String TYPE_NAME = "link";
        
    private GcWebResource resource;

    public GcLink(XmlElement target) {
        super(target);
    }

    public GcLink(URI href, String rel) {
        super(builder.newFragment(TYPE_NS, TYPE_NAME));
        setHref(href.toString());
        setRel(rel);
    }
    
    public void setHref(String href) {
        xml().setAttributeValue("href", href);
    }
    
    public String getHref() {
        return  xml().attributeValue("href");
    }
    
    public void setRel(String rel) {
        xml().setAttributeValue("rel", rel);
    }
    
    public String getRel() {
        return xml().attributeValue("rel");
    }
    
    public XmlNamespace xmlTypeNs() { return TYPE_NS; }
    public String xmlTypeName() { return TYPE_NAME; }
    
}

