/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/* Copyright (c) 2005 Extreme! Lab, Indiana University. All rights reserved.
 * This software is open source. See the bottom of this file for the license.
 * $Id: GcProcessResource.java,v 1.5 2006/12/07 04:55:28 aslom Exp $ */
package org.gpel.client;

import org.gpel.GpelConstants;
import org.xmlpull.infoset.XmlElement;
import org.gpel.model.GpelProcess;

public class GcProcessResource extends GcXmlWebResource {
    public final static String MIME_TYPE = "application/x-gpel+xml";
    private final static String REL = GpelConstants.REL_PROCESS;
    
    public GcProcessResource(String title, GpelProcess process) {
        super(title, process.xml(), MIME_TYPE);
    }

    public GcProcessResource(XmlElement atomRes) {
        super(atomRes);
    }
    
//    public GcProcessResource(XmlElement wrapped) {
//        super(wrapped);
//        process();
//    }
    
    public GpelProcess process() {
        return getXmlContent().viewAs(GpelProcess.class);
    }
    
    public String getRel() {
        return REL;
    }
    
    public void setRel(String rel) {
        if (rel == null) throw new IllegalArgumentException();
        if (! REL.equals(rel)) {
            throw new GcException(
                "only rel " + REL + " is suported for Process resource not " + rel);
        }
    }
}


