/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/* Copyright (c) 2005 Extreme! Lab, Indiana University. All rights reserved.
 * This software is open source. See the bottom of this file for the license.
 * $Id: GcTemplate.java,v 1.20 2006/12/07 04:55:28 aslom Exp $ */
package org.gpel.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gpel.GpelConstants;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlInfosetBuilder;

public class GcTemplate extends GcLinksResource {
    private final static XmlInfosetBuilder builder = GpelConstants.BUILDER;
    public final static String MIME_TYPE = "application/x-gpel-template+xml";
    public final static String TYPE_NAME = "template";
    
    protected GcTemplate(GpelClient client, String title, GcLinkFilter filter)
    throws GcException {
        super(client, title, builder.newFragment(GpelConstants.GPEL_NS, TYPE_NAME),
              filter, MIME_TYPE);
    }
    
//    protected GcTemplate(GpelClient client, GcXmlWebResource atomRes, GcLinkFilter filter)
//    throws GcException {
//        super(client, atomRes, filter);
//    }

    public GcTemplate(XmlElement atomRes) {
        super(atomRes);
    }
    
    public GcInstance createInstance() {
        return getClient().createInstance(this);
    }
    
    
    public URI getTemplateId() throws GcException {
        return getId();
    }
    
    
}

