/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/* Copyright (c) 2005 Extreme! Lab, Indiana University. All rights reserved.
 * This software is open source. See the bottom of this file for the license.
 * $Id: GcUtil.java,v 1.9 2006/12/07 04:55:28 aslom Exp $ */
package org.gpel.client;

import org.gpel.GpelConstants;
import org.xmlpull.infoset.XmlNamespace;

public class GcUtil {
    public static final String DEFAULT_CHARSET = "utf-8";
    public static final String ATOM_MIMETYPE = "application/atom+xml";
    public static final String XML_MIMETYPE = "application/xml";
    public static final String CONTENT_TYPE_ATOM = ATOM_MIMETYPE + "; charset="+DEFAULT_CHARSET;

    public final static String NS_URI_ATOM = GpelConstants.NS_URI_ATOM;
    public final static XmlNamespace ATOM_NS = GpelConstants.ATOM_NS;
    
    public static final String ATOM_ENTRY_EL = "entry";
    public static final String ATOM_CONTENT_EL = "content";
    public static final String ATOM_CONTENT_TYPE_ATTR = "type";
    public static final String ATOM_TITLE_EL = "title";
    public static final String ATOM_UPDATED_EL = "updated";
    
    public static final String GPEL_SPACE_GUID = "gpel.space.guid";
    public static final String GPEL_SPACE_LOC = "gpel.space.loc";
    public static final String GPEL_SPACE_POST = "gpel.space.post";
    
    public static GcWebResourceType categorizeContentType(String contentType) {
        if (contentType == null) throw new IllegalArgumentException();
        
        // emove optional parameters such as  ;charset=utf-8
        int scPos = contentType.indexOf(";");
        if (scPos != -1) {
            contentType = contentType.substring(0, scPos);
        }
        contentType = contentType.trim();
        
        // this heuristic for Content-type is inspired by ATOM 1.0
        //http://atompub.org/2005/08/17/draft-ietf-atompub-format-11.html#atomContent
        //If the value of "type" is "text",
        //If the value of "type" is "html",
        //If the value of "type" is "xhtml",
        //+xml" or "/xml" (case-insensitive),
        //type" begins with "text/" (case-insensitive)
        //otherwise it is binary
        GcWebResourceType guess;
        if (contentType.endsWith("/xml") || contentType.endsWith("+xml")
            || contentType.equals("xhtml")) { //special for ATOM
            guess = GcWebResourceType.XML;
        } else if (contentType.startsWith("text/")
                 || contentType.equals("html") || contentType.equals("text")) { //special for ATOM
            guess = GcWebResourceType.TEXT;
        } else {
            guess = GcWebResourceType.BINARY;
        }
        return guess;
    }
    
    
}

