/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/* Copyright (c) 2005 Extreme! Lab, Indiana University. All rights reserved.
 * This software is open source. See the bottom of this file for the license.
 * $Id: GcXmlWebResource.java,v 1.9 2006/12/07 04:55:28 aslom Exp $ */
package org.gpel.client;

import java.net.URI;
import org.gpel.GpelConstants;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlInfosetBuilder;
import org.xmlpull.infoset.XmlNamespace;
import org.xmlpull.infoset.view.TypedXmlElementView;

public class GcXmlWebResource extends GcAtomResource implements GcWebResource {
    private final static XmlInfosetBuilder builder = GpelConstants.BUILDER;
    private final static String DEFAULT_MIME_TYPE = "application/xml";
    
    public GcXmlWebResource(String resourceName, XmlElement wrapped, String mimeType) {
        //LATER: use ATOMIXMISER?
        super(resourceName, mimeType);
        if (wrapped == null) throw new IllegalArgumentException();
        setXmlContent(wrapped);
        //builder.newFragment(GpelConstants.GPEL_NS, GcTemplate.TYPE_NAME);
        //loadResourcesFromLinks();
    }

    public GcXmlWebResource(XmlElement atomRes) {
        super(atomRes);
    }
        
    public XmlElement getXmlContent() {
        XmlElement el;
        XmlElement contentEl = getContentEl(true);
        if (contentEl != null) {
            // first child of it
            el = contentEl.requiredElementContent().iterator().next();
        } else {
            el = xml();
            //throw new IllegalStateException("missing content");
        }
        return el;
    }
    
    public void setXmlContent(XmlElement xmlContent) {
        XmlElement contentEl = getContentEl(true);
        if (contentEl == null) {
            throw new GcException("XML resource must be first saved to have modifiable content");
        }
        contentEl.removeAllChildren();
        contentEl.addChild(xmlContent);
    }
    
    public void setMimeType(String mimeType) {
        if (mimeType == null) throw new IllegalArgumentException();
        if (!GcWebResourceType.XML.equals(GcUtil.categorizeContentType(mimeType))) {
            throw new IllegalArgumentException("content type must be xml and not " + mimeType);
        }
        super.setMimeType(mimeType);
    }
    
}

