/* -*- mode: Java; c-basic-offset: 4; indent-tabs-mode: nil; -*-  //------100-columns-wide------>|*/
/* Copyright (c) 2005 Extreme! Lab, Indiana University. All rights reserved.
 * This software is open source. See the bottom of this file for the license.
 * $Id: GcDefaultWebResourceFromHttp.java,v 1.10 2006/12/07 04:55:30 aslom Exp $ */
package org.gpel.client.http;

import org.gpel.client.*;

import org.gpel.GpelConstants;
import org.gpel.client.http.GcHttpResponse;
import org.gpel.client.util.base64.Base64;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlInfosetBuilder;
import org.xmlpull.infoset.view.XmlValidationException;

public class GcDefaultWebResourceFromHttp implements GcWebResourceFromHttp {
    private final static XmlInfosetBuilder builder = GpelConstants.BUILDER;
    
    public static GcDefaultWebResourceFromHttp getInstance() {
        return new GcDefaultWebResourceFromHttp();
    }
    
    public GcWebResource createResourceFromHttp(GcHttpResponse resp, String rel) throws GcException {
        String contentType = resp.getContentType();
        GcWebResource resource = null;
        GcWebResourceType resType = GcUtil.categorizeContentType(contentType);
        //boolean needsWrapping = true;
        String title = "No title";
        if (GcWebResourceType.XML.equals(resType)) {
            XmlElement el = resp.getXmlContent();
            if (el.getNamespace().equals(GcUtil.ATOM_NS) && el.getName().equals(GcUtil.ATOM_ENTRY_EL)) {
                XmlElement titleEl = el.element(GcUtil.ATOM_NS, GcUtil.ATOM_TITLE_EL);
                if (titleEl == null) {
                    throw new XmlValidationException("missing atom:title in " + builder.serializeToString(el));
                }
                title = titleEl.requiredText(); //LATER use ATOMIX::getTitelSsText
                XmlElement contentEl = el.element(GcUtil.ATOM_NS, GcUtil.ATOM_CONTENT_EL);
                if (contentEl != null) {
                    String atomContType = contentEl.attributeValue(GcUtil.ATOM_CONTENT_TYPE_ATTR);
                    //LATER deal with TEXT, HTML and XHTML
                    if (atomContType != null) {
                        contentType = atomContType;
                    }
                    GcWebResourceType atomResType = GcUtil.categorizeContentType(atomContType);
                    if (GcWebResourceType.XML.equals(atomResType)) {
                        resource = new GcXmlWebResource(el);
                    } else if (GcWebResourceType.TEXT.equals(atomResType)) {
                        //String text = contentEl.requiredText();
                        resource = new GcTextWebResource(el);
                    } else if (GcWebResourceType.BINARY.equals(atomResType)) {
                        //String text = contentEl.requiredText();
                        //byte[] binary = Base64.decode(text.toCharArray());
                        resource = new GcBinaryWebResource(el);
                    } else {
                        throw new IllegalStateException("" + atomResType);
                    }
                } else {
                    throw new IllegalStateException("missing atom:content");
                }
                //needsWrapping = false;
            }
        }
        if (resource == null) { //needsWrapping) {
            XmlElement atomEl = builder.newFragment(GcUtil.ATOM_NS, GcUtil.ATOM_ENTRY_EL);
            XmlElement titleEl = atomEl.addElement(GcUtil.ATOM_NS, GcUtil.ATOM_TITLE_EL);
            XmlElement contentEl = atomEl.addElement(GcUtil.ATOM_NS, GcUtil.ATOM_CONTENT_EL);
            contentEl.setAttributeValue(GcUtil.ATOM_CONTENT_TYPE_ATTR, contentType);
            
            if (GcWebResourceType.XML.equals(resType)) {
                XmlElement el = resp.getXmlContent();
                contentEl.addChild(el);
                resource = new GcXmlWebResource(atomEl);
                //TODO: add el.viewAs(GpelProcess.class)
            } else if (GcWebResourceType.TEXT.equals(resType)) {
                String text = resp.getTextContent();
                if (text == null) {
                    //XmlElement el = resp.getXmlContent();
                    //resource = new GcTextWebResource(el);
                    throw new IllegalStateException("missing text content");
                } else {
                    contentEl.addChild(text);
                    resource = new GcTextWebResource(atomEl);
                }
            } else if (GcWebResourceType.BINARY.equals(resType)) {
                byte[] binary = resp.getBinaryContent();
                String s = new String(Base64.encode(binary));
                contentEl.addChild(s);
                resource = new GcBinaryWebResource(atomEl);
            } else {
                throw new GcException("unsupported content type " + contentType);
            }
            titleEl.setText(title);
        }
//        if (optionalRel != null) {
//            resource.setRel(optionalRel);
//        }
        resource.setMimeType(contentType);
        
        String mimeType  = resource.getMimeType();
        // now do additional onversions
//        GcWebResource oldResource = resource;
        if (mimeType.equals(GcProcessResource.MIME_TYPE)) {
            resource = new GcProcessResource(((GcAtomResource)resource).xml());
        } else if (mimeType.equals(GcWsdlResource.MIME_TYPE)) {
            XmlElement resXml = ((GcAtomResource)resource).xml();
            if (rel == null || rel.equals(GcWsdlResource.REL)) {
                resource = new GcWsdlResource(resXml);
            } else if (rel.equals(GcUsesWsdlResource.REL)) {
                resource = new GcUsesWsdlResource(resXml);
            } else if (rel.equals(GcProvidesWsdlResource.REL)) {
                resource = new GcProvidesWsdlResource(resXml);
            } else {
                throw new GcException("unsupported rel "+rel+" for WSDl resource "+resp);
            }
        } else if (mimeType.equals(GcTemplate.MIME_TYPE)) {
            resource = new GcTemplate(((GcAtomResource)resource).xml());
        } else if (mimeType.equals(GcInstance.MIME_TYPE)) {
            resource = new GcInstance(((GcAtomResource)resource).xml());
        } else if (mimeType.equals(GcState.MIME_TYPE)) {
            resource = new GcState(((GcAtomResource)resource).xml());
        } else if (mimeType.equals(GcIncomingQueue.MIME_TYPE)) {
            resource = new GcIncomingQueue(((GcAtomResource)resource).xml());
        } else if (mimeType.equals(GcOutgoingQueue.MIME_TYPE)) {
            resource = new GcOutgoingQueue(((GcAtomResource)resource).xml());
        }
//        if(oldResource != resource) {
//            resource.setLocation( oldResource.getLocation() );
////            if(oldResource.getRel() != null) {
////              resource.setRel( oldResource.getRel() );
////            }
//        }
        return resource;
    }
    
}

